/*
 * JBoss, Home of Professional Open Source
 * Copyright 2009, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.managed.plugins;

import java.util.Set;

import org.jboss.managed.api.ManagedOperation;
import org.jboss.managed.api.ManagedParameter;
import org.jboss.metatype.api.types.MetaType;

/**
 * @author Scott.Stark@jboss.org
 * @version $Revision:$
 */
public class ManagedOperationMatcher
{
   public static ManagedOperation findOperation(Set<ManagedOperation> ops, String name,
         MetaType... signature)
   {
      ManagedOperation match = null;
      for(ManagedOperation op : ops)
      {
         if(op.getName().equals(name))
         {
            // Validate parameters
            ManagedParameter[] params = op.getParameters();
            if(params != null)
            {
               int paramLength = params.length;
               int sigLength = signature.length;
               if(paramLength != sigLength)
                  continue;

               boolean sigMatches = true;
               for(int n = 0; n < sigLength; n ++)
               {
                  ManagedParameter mp = params[n];
                  MetaType mps = mp.getMetaType();
                  MetaType sig = signature[n];
                  if(mps.equals(sig) == false)
                  {
                     sigMatches = false;
                     break;
                  }  
               }
               if(sigMatches)
               {
                  // We have a match 
                  match = op;
                  break;
               }
            }
            else if(signature == null || signature.length == 0)
            {
               match = op;
               break;
            }
         }
      }
      return match;
   }
}
