/*
 * JBoss, Home of Professional Open Source
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.managed.plugins.jmx;

import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;

import org.jboss.metatype.api.types.CompositeMetaType;
import org.jboss.metatype.api.types.ImmutableCompositeMetaType;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.values.CompositeValueSupport;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.MetaValueFactory;
import org.jboss.metatype.spi.values.MetaValueBuilder;

/**
 * @author Scott.Stark@jboss.org
 * @version $Revision: 85723 $
 */
public class CompositeDataMetaValueBuilder implements MetaValueBuilder
{
   MetaValueFactory metaValueFactory;

   public MetaValueFactory getMetaValueFactory()
   {
      return metaValueFactory;
   }
   public void setMetaValueFactory(MetaValueFactory metaValueFactory)
   {
      this.metaValueFactory = metaValueFactory;
   }


   public MetaValue buildMetaValue(MetaType metaType, Object object)
   {
      if((object instanceof CompositeData) == false)
         return null;
      CompositeData cd = (CompositeData) object;
      CompositeType ct = cd.getCompositeType();
      String[] itemNames = new String[ct.keySet().size()];
      String[] itemDescriptions = new String[itemNames.length];
      MetaValue[] itemValues = new MetaValue[itemNames.length];
      MetaType[] itemTypes = new MetaType[itemNames.length];
      ct.keySet().toArray(itemNames);
      Object[] cdValues = cd.getAll(itemNames);
      for(int n = 0; n < cdValues.length; n ++)
      {
         String itemName = itemNames[n];
         Object ov = cdValues[n];
         itemDescriptions[n] = ct.getDescription(itemName);
         OpenType ot = ct.getType(itemName);
         try
         {
            itemTypes[n] = ManagementFactoryUtils.getMetaType(ot);
         }
         catch(Exception e)
         {
            e.printStackTrace();
         }
         MetaValue mv = metaValueFactory.create(ov, itemTypes[n]);
         itemValues[n] = mv;
      }
      
      String typeName = ct.getTypeName();
      String description = ct.getDescription();
      CompositeMetaType cmt = new ImmutableCompositeMetaType(typeName, description, itemNames, itemDescriptions, itemTypes);
      CompositeValueSupport cv = new CompositeValueSupport(cmt, itemNames, itemValues);
      return cv;
   }

}
