/*
 * JBoss, Home of Professional Open Source
 * Copyright 2009, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.metatype.values.factory.test;

import java.util.Hashtable;

import javax.management.ObjectName;

import org.jboss.metatype.api.types.SimpleMetaType;
import org.jboss.metatype.api.values.CompositeValue;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.PropertiesMetaValue;

/**
 * @author Scott.Stark@jboss.org
 * @version $Revision:$
 */
public class ObjectNameUnitTestCase extends AbstractMetaValueFactoryTest
{

   public ObjectNameUnitTestCase(String name)
   {
      super(name);
   }

   /**
    * Test ObjectName(String, Hashtable)
    * @throws Exception
    */
   public void testObjectNameMVCreation()
      throws Exception
   {
      Hashtable keys = new Hashtable();
      keys.put("key1", "value1");
      keys.put("key1", "value1");
      ObjectName on = new ObjectName("testObjectNameMVCreation", keys);
      MetaValue mv = super.createMetaValue(on);
      log.debug(mv);
      assertTrue("is a CompositeValue", mv instanceof CompositeValue);

      CompositeValue cv = (CompositeValue) mv;
      MetaValue domainMV = cv.get("domain");
      assertNotNull(domainMV);
      assertTrue("domain is a STRING", domainMV.getMetaType() == SimpleMetaType.STRING);
      MetaValue keyPropertyList = cv.get("keyPropertyList");
      assertNotNull(keyPropertyList);
      assertTrue("keyPropertyList is a Properties", keyPropertyList instanceof PropertiesMetaValue);

      ObjectName on2 = (ObjectName) super.unwrapMetaValue(mv);
      assertEquals(on, on2);
   }
   /**
    * Test ObjectName(String)
    * @throws Exception
    */
   public void testObjectNameMVCreation2()
      throws Exception
   {
      ObjectName on = new ObjectName("testObjectNameMVCreation2:key1=value1,key2=value2");
      MetaValue mv = super.createMetaValue(on);
      log.debug(mv);
      assertTrue("is a CompositeValue", mv instanceof CompositeValue);

      CompositeValue cv = (CompositeValue) mv;
      MetaValue domainMV = cv.get("domain");
      assertNotNull(domainMV);
      assertTrue("domain is a STRING", domainMV.getMetaType() == SimpleMetaType.STRING);
      MetaValue keyPropertyList = cv.get("keyPropertyList");
      assertNotNull(keyPropertyList);
      assertTrue("keyPropertyList is a Properties", keyPropertyList instanceof PropertiesMetaValue);

      ObjectName on2 = (ObjectName) super.unwrapMetaValue(mv);
      assertEquals(on, on2);
   }


}
