/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2009, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.test.metatype.plugins.values.mappers.test;

import java.util.Hashtable;

import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

import junit.framework.TestCase;

import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.plugins.values.mappers.PropertiesCompositeObjectNameMetaMapper;

/**
 *
 *
 * @author Brian Stansberry
 * 
 * @version $Revision: $
 */
public class PropertiesCompositeObjectNameMetaMapperUnitTestCase extends TestCase
{
   private PropertiesCompositeObjectNameMetaMapper mapper;
   
   
   

   @Override
   protected void setUp() throws Exception
   {
      super.setUp();
      
      mapper = new PropertiesCompositeObjectNameMetaMapper();
   }

   /**
    * Test method for {@link org.jboss.metatype.plugins.values.mappers.PropertiesCompositeObjectNameMetaMapper#mapToType()}.
    */
   public void testMapToType()
   {
      assertEquals(ObjectName.class, mapper.mapToType());
   }

   /**
    * Tests that the result of a call to 
    * {@link PropertiesCompositeObjectNameMetaMapper#createMetaValue(org.jboss.metatype.api.types.MetaType, ObjectName) createMetaValue} 
    * passed to {@link PropertiesCompositeObjectNameMetaMapper#unwrapMetaValue(org.jboss.metatype.api.values.MetaValue) unwrapMetaValue}
    * results in the equivalent object name as what was passed in.
    */
   public void testRoundTrip() throws MalformedObjectNameException
   {
      Hashtable<String, String> keys = new Hashtable<String, String>();
      keys.put("key1", "value1");
      keys.put("key1", "value1");
      ObjectName input = new ObjectName("testRoundTrip", keys);
      
      MetaValue mv = mapper.createMetaValue(mapper.getMetaType(), input);
      
      ObjectName output = mapper.unwrapMetaValue(mv);
      
      assertEquals(input, output);
      
   }

}
