/*
 * JBoss, Home of Professional Open Source
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.managed.factory.support.mcf;


import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.managed.api.factory.ManagedObjectFactory;
import org.jboss.managed.plugins.factory.AbstractInstanceClassFactory;
import org.jboss.metadata.spi.MetaData;
import org.jboss.metatype.api.types.SimpleMetaType;
import org.jboss.metatype.api.values.MapCompositeValueSupport;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.SimpleValueSupport;

/**
 * An InstanceClassFactory for LocalDataSourceDeploymentMetaData that handles
 * connection-properties property as a MapCompositeValueSupport.
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision: 78217 $
 */
public class LocalDSInstanceClassFactory
   extends AbstractInstanceClassFactory<LocalDataSourceDeploymentMetaData>
{
   public LocalDSInstanceClassFactory()
   {
      super();
   }
   public LocalDSInstanceClassFactory(ManagedObjectFactory mof)
   {
      super(mof);
   }

   public Class<LocalDataSourceDeploymentMetaData> getType()
   {
      return LocalDataSourceDeploymentMetaData.class;
   }
   public Class<? extends Serializable> getManagedObjectClass(
         LocalDataSourceDeploymentMetaData attachment)
         throws ClassNotFoundException
   {
      return attachment.getClass();
   }

   public MetaValue getValue(BeanInfo beanInfo, ManagedProperty property,
         MetaData metaData,
         LocalDataSourceDeploymentMetaData attachment)
   {
      MetaValue value = null;
      if("connection-properties".equals(property.getName()))
      {
         MapCompositeValueSupport mapValue = new MapCompositeValueSupport(SimpleMetaType.STRING);
         List<DataSourceConnectionPropertyMetaData> list = attachment.getDataSourceConnectionProperties();
         if(list != null)
         {
            for(DataSourceConnectionPropertyMetaData prop : list)
            {
               MetaValue wrapped = SimpleValueSupport.wrap(prop.getValue());
               mapValue.put(prop.getName(), wrapped);
            }
         }
         value = mapValue;
      }
      else if("config-property".equals(property.getName()))
      {
         MapCompositeValueSupport mapValue = new MapCompositeValueSupport(SimpleMetaType.STRING);
         List<ManagedConnectionFactoryPropertyMetaData> list = attachment.getManagedConnectionFactoryProperties();
         if(list != null)
         {
            for(ManagedConnectionFactoryPropertyMetaData prop : list)
            {
               mapValue.put("name", SimpleValueSupport.wrap(prop.getName()));
               mapValue.put("value", SimpleValueSupport.wrap(prop.getValue()));
               mapValue.put("type", SimpleValueSupport.wrap("java.lang.String"));
            }
         }
         value = mapValue;
      }
      else
      {
         value = super.getValue(beanInfo, property, metaData, attachment);
      }
      return value;
   }

   @Override
   protected Object unwrapValue(BeanInfo beanInfo, ManagedProperty property,
         MetaValue value)
   {
      if((value instanceof MapCompositeValueSupport) == false)
      {
         return super.unwrapValue(beanInfo, property, value);
      }

      MapCompositeValueSupport mapValue = (MapCompositeValueSupport) value;
      Object unwrapValue = null;
      if("connection-properties".equals(property.getName()))
      {
         List<DataSourceConnectionPropertyMetaData> list = new ArrayList<DataSourceConnectionPropertyMetaData>();
         for(String name : mapValue.getMetaType().keySet())
         {
            DataSourceConnectionPropertyMetaData prop = new DataSourceConnectionPropertyMetaData();
            prop.setName(name);
            String svalue = (String) getMetaValueFactory().unwrap(mapValue.get(name));
            prop.setValue(svalue);
            list.add(prop);
         }
         unwrapValue = list;
      }
      else if("config-property".equals(property.getName()))
      {
         List<ManagedConnectionFactoryPropertyMetaData> list = new ArrayList<ManagedConnectionFactoryPropertyMetaData>();
         for(String name : mapValue.getMetaType().keySet())
         {
            ManagedConnectionFactoryPropertyMetaData prop = new ManagedConnectionFactoryPropertyMetaData();
            prop.setName(name);
            String svalue = (String) getMetaValueFactory().unwrap(mapValue.get(name));
            prop.setValue(svalue);
            prop.setType("java.lang.String");
            list.add(prop);
         }
         unwrapValue = list;
      }
      return unwrapValue;
   }
}
