/*
 * JBoss, Home of Professional Open Source
 * Copyright 2009, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.managed.factory.support;

import java.io.Serializable;

import org.jboss.managed.api.annotation.ManagementObject;
import org.jboss.managed.api.annotation.ManagementProperty;

/**
 * Test of read only properties
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision: 86627 $
 */
@ManagementObject
public class ManagementPropertyReadOnly
   implements Serializable
{
   private static final long serialVersionUID = 1;
   private String readOnly = "readOnly";
   private String readOnly2 = "readOnly2";
   private String readWrite = "readWrite";
   private String readWrite2 = "readWrite2";

   public String getReadOnly()
   {
      return readOnly;
   }
   
   public String getReadOnly2()
   {
      return readOnly2;
   }
   @ManagementProperty(readOnly=true)
   public void setReadOnly2(String x)
   {
      readOnly2 = x;
   }
   public String getReadWrite()
   {
      return readWrite;
   }
   @ManagementProperty(readOnly=false)
   public void setReadWrite(String x)
   {
      x = readWrite;
   }
   public String getReadWrite2()
   {
      return readWrite2;
   }
   @ManagementProperty()
   public void setReadWrite2(String x)
   {
      readWrite2 = x;
   }
}
