/*
 * JBoss, Home of Professional Open Source
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.managed.plugins.constraints;

import java.lang.reflect.Method;

import org.jboss.beans.info.spi.PropertyInfo;
import org.jboss.managed.api.Fields;
import org.jboss.managed.spi.factory.ManagedPropertyConstraintsPopulator;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.SimpleValueSupport;

/**
 * A ManagedPropertyConstraintsPopulator for Number min/max values
 * @author Scott.Stark@jboss.org
 * @version $Revision: 81573 $
 */
public class NumberConstraintsPopulator
   implements ManagedPropertyConstraintsPopulator
{
   Number min;
   Number max;

   private static boolean isFloat(String str)
   {
      boolean isFloat = false;
      if(str != null)
         isFloat = str.indexOf('.') >= 0;
      return isFloat;
   }

   public NumberConstraintsPopulator(String min, String max, String numberClassName)
      throws Exception
   {
      Class<?> numberClass;

      if(numberClassName != null)
      {
         numberClass = Class.forName(numberClassName);
      }
      else if(isFloat(min) || isFloat(max))
      {
         numberClass = Double.class;
      }
      else
      {
         numberClass = Long.class;
      }

      Class<?>[] sig = {String.class};
      Method parse = numberClass.getDeclaredMethod("valueOf", sig);
      if(min != null)
      {
         Object[] args = {min};
         Number n = (Number) parse.invoke(null, args);
         setMin(n);
      }
      if(max != null)
      {
         Object[] args = {max};
         Number n = (Number) parse.invoke(null, args);
         setMax(n);
      }
   }

   public Number getMin()
   {
      return min;
   }
   public void setMin(Number min)
   {
      this.min = min;
   }

   public Number getMax()
   {
      return max;
   }
   public void setMax(Number max)
   {
      this.max = max;
   }

   public void populateManagedProperty(Class attachmentClass,
         PropertyInfo info, Fields fields)
   {
      if(min != null)
      {
         MetaValue minMV = SimpleValueSupport.wrap(min);
         fields.setField(Fields.MINIMUM_VALUE, minMV);
      }
      if(max != null)
      {
         MetaValue maxMV = SimpleValueSupport.wrap(max);
         fields.setField(Fields.MAXIMUM_VALUE, maxMV);
      }
   }

}
