/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metatype.api.values;

import java.util.Arrays;
import java.util.Iterator;
import org.jboss.metatype.api.types.CollectionMetaType;
import org.jboss.metatype.api.values.AbstractMetaValue;
import org.jboss.metatype.api.values.CollectionValue;
import org.jboss.metatype.api.values.MetaValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionValueSupport
extends AbstractMetaValue
implements CollectionValue {
    private static final long serialVersionUID = 1131827130033538066L;
    private CollectionMetaType metaType;
    private MetaValue[] elements;

    public CollectionValueSupport(CollectionMetaType metaType) {
        if (metaType == null) {
            throw new IllegalArgumentException("Null collection meta type");
        }
        this.metaType = metaType;
    }

    public CollectionValueSupport(CollectionMetaType metaType, MetaValue[] elements) {
        this(metaType);
        this.elements = elements;
    }

    @Override
    public CollectionMetaType getMetaType() {
        return this.metaType;
    }

    @Override
    public MetaValue[] getElements() {
        return this.elements;
    }

    @Override
    public int getSize() {
        return this.elements != null ? this.elements.length : 0;
    }

    @Override
    public Iterator<MetaValue> iterator() {
        return new ElementsIterator(this.elements);
    }

    public void setElements(MetaValue[] elements) {
        this.elements = elements;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof CollectionValue)) {
            return false;
        }
        CollectionValue other = (CollectionValue)obj;
        if (!this.metaType.equals(other.getMetaType())) {
            return false;
        }
        Object[] otherElements = other.getElements();
        if (this.elements == null) {
            return otherElements == null;
        }
        return otherElements != null && Arrays.equals(this.elements, otherElements);
    }

    public int hashCode() {
        if (this.elements == null) {
            return 0;
        }
        return this.elements.hashCode();
    }

    public String toString() {
        return this.metaType + ": " + this.elements;
    }

    @Override
    public MetaValue clone() {
        CollectionValueSupport result = (CollectionValueSupport)super.clone();
        int size = this.getSize();
        if (size > 0) {
            result.elements = new MetaValue[size];
            System.arraycopy(this.elements, 0, result.elements, 0, size);
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ElementsIterator
    implements Iterator<MetaValue> {
        private int index;
        private int length;
        private MetaValue[] elements;

        ElementsIterator(MetaValue[] elements) {
            this.elements = elements;
            this.index = 0;
            this.length = elements != null ? elements.length : 0;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.length;
        }

        @Override
        public MetaValue next() {
            return this.elements[this.index++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

