/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.spi.scope;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.metadata.spi.scope.CommonLevels;
import org.jboss.metadata.spi.scope.ScopeLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonLevelsUtil {
    private static final List<ScopeLevel> levels = new ArrayList<ScopeLevel>();
    private static final int size;

    public static List<ScopeLevel> getSubLevels(ScopeLevel level) {
        int index = levels.indexOf(level);
        if (index < 0) {
            throw new IllegalArgumentException("No such scope level in levels: " + level);
        }
        return levels.subList(index, size);
    }

    public static List<ScopeLevel> getExclusiveSubLevels(ScopeLevel level) {
        int index = levels.indexOf(level);
        if (index < 0) {
            throw new IllegalArgumentException("No such scope level in levels: " + level);
        }
        if (index + 1 == size) {
            return Collections.emptyList();
        }
        return levels.subList(index + 1, size);
    }

    static {
        levels.add(CommonLevels.DOMAIN);
        levels.add(CommonLevels.CLUSTER);
        levels.add(CommonLevels.MACHINE);
        levels.add(CommonLevels.NODE);
        levels.add(CommonLevels.JVM);
        levels.add(CommonLevels.SERVER);
        levels.add(CommonLevels.SUBSYSTEM);
        levels.add(CommonLevels.APPLICATION);
        levels.add(CommonLevels.DEPLOYMENT);
        levels.add(CommonLevels.CLASS);
        levels.add(CommonLevels.INSTANCE);
        levels.add(CommonLevels.JOINPOINT);
        levels.add(CommonLevels.JOINPOINT_OVERRIDE);
        levels.add(CommonLevels.THREAD);
        levels.add(CommonLevels.WORK);
        levels.add(CommonLevels.REQUEST);
        Collections.sort(levels);
        size = levels.size();
    }
}

