/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metatype.plugins.values.mappers;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.types.PropertiesMetaType;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.PropertiesMetaValue;
import org.jboss.metatype.spi.values.MetaMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesObjectNameMetaMapper
extends MetaMapper<ObjectName> {
    PropertiesMetaType type;

    public PropertiesObjectNameMetaMapper() {
        this(null);
    }

    public PropertiesObjectNameMetaMapper(String ... args) {
        Map<String, String> propertyNameDescriptions = Collections.emptyMap();
        if (args != null) {
            if (!(args.length % 2 == 0)) {
                throw new IllegalStateException("args counts must be 2*n for n key,key-description pairs");
            }
            propertyNameDescriptions = new HashMap<String, String>();
            propertyNameDescriptions.put("domain", "the object name domain");
            for (int n = 0; n < args.length; n += 2) {
                String key = args[n];
                String description = args[n + 1];
                propertyNameDescriptions.put(key, description);
            }
        }
        this.type = new PropertiesMetaType("java.util.Properties", propertyNameDescriptions);
    }

    @Override
    public MetaType getMetaType() {
        return this.type;
    }

    @Override
    public Type mapToType() {
        return ObjectName.class;
    }

    @Override
    public MetaValue createMetaValue(MetaType metaType, ObjectName object) {
        String domain = object.getDomain();
        Hashtable<String, String> props = object.getKeyPropertyList();
        PropertiesMetaValue map = PropertiesMetaValue.wrap(props);
        map.put("domain", domain);
        return map;
    }

    @Override
    public ObjectName unwrapMetaValue(MetaValue metaValue) {
        PropertiesMetaValue map = (PropertiesMetaValue)metaValue;
        String domain = (String)map.remove("domain");
        try {
            return PropertiesObjectNameMetaMapper.createObjectName(domain, map);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to build ObjectName from MetaValue: " + metaValue, e);
        }
    }

    public static ObjectName createObjectName(String domain, PropertiesMetaValue props) throws MalformedObjectNameException {
        if (props == null) {
            return new ObjectName(domain);
        }
        Hashtable<String, String> table = new Hashtable<String, String>();
        Enumeration<?> enumeration = props.propertyNames();
        while (enumeration.hasMoreElements()) {
            Object key = enumeration.nextElement();
            if (!(key instanceof String)) continue;
            String stringKey = (String)key;
            String property = props.getProperty(stringKey);
            table.put(stringKey, property);
        }
        return new ObjectName(domain, table);
    }
}

