/*
 * JBoss, Home of Professional Open Source
 * Copyright 2009, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.managed.factory.support;

import java.io.Serializable;

import org.jboss.managed.api.annotation.ManagementObject;
import org.jboss.managed.api.annotation.ManagementProperty;
import org.jboss.managed.api.annotation.Masked;

/**
 * Test of masked properties
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision: 87263 $
 */
@ManagementObject
public class ManagementPropertyMasked
   implements Serializable
{
   private static final long serialVersionUID = 1;
   private String masked1 = "masked1";
   private String masked2 = "masked2";

   public String getMasked1()
   {
      return masked1;
   }
   @ManagementProperty()
   @Masked(options={"hashAlgorithm", "MD5"})
   public void setMasked1(String masked1)
   {
      this.masked1 = masked1;
   }

   public String getMasked2()
   {
      return masked2;
   }
   @ManagementProperty(readOnly=true)
   @Masked
   public void setMasked2(String masked2)
   {
      this.masked2 = masked2;
   }
}
