/*
 * JBoss, Home of Professional Open Source
 * Copyright 2009, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.managed.factory.support;

import java.lang.annotation.Annotation;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import org.jboss.annotation.factory.AnnotationProxy;
import org.jboss.managed.api.DeploymentTemplateInfo;
import org.jboss.managed.api.annotation.ManagementObjectID;
import org.jboss.managed.plugins.BasicDeploymentTemplateInfo;
import org.jboss.managed.plugins.DefaultFieldsImpl;
import org.jboss.managed.plugins.ManagedObjectImpl;
import org.jboss.managed.plugins.ManagedPropertyImpl;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.types.SimpleMetaType;
import org.jboss.metatype.api.values.MetaValue;

/**
 * @author Scott.Stark@jboss.org
 * @version $Revision:$
 */
public class JmsDestinationTemplateInfo extends BasicDeploymentTemplateInfo
{
   private static final long serialVersionUID = 1;
   private String destinationType = "queue";
   
   public JmsDestinationTemplateInfo(String name, String description, String destinationType)
   {
      super(name, description);
      this.destinationType = destinationType;
      super.setRootManagedPropertyName("services");

      ManagedObjectImpl mo;
      if("queue".equals(destinationType))
         mo = new ManagedObjectImpl("org.jboss.jms.server.destination.QueueServiceMO");
      else if("topic".equals(destinationType))
         mo = new ManagedObjectImpl("org.jboss.jms.server.destination.TopicServiceMO");
      else
         throw new IllegalStateException("Unexpected destination type: " + destinationType);

      addManagedProperty("name", "The destination name", true, false, SimpleMetaType.STRING, mo);
      addManagedProperty("JNDIName", "The destination's JNDI name", false, true, SimpleMetaType.STRING, mo);
   }
   
   
   public String getDestinationType()
   {
      return destinationType;
   }


   @Override
   public JmsDestinationTemplateInfo copy()
   {
      JmsDestinationTemplateInfo copy = new JmsDestinationTemplateInfo(getName(), getDescription(), destinationType);
      super.copy(copy);
      return copy;
   }

   private void addManagedProperty(String fieldName,
                                   String fieldDescr,
                                   boolean mandatory,
                                   boolean isID,
                                   MetaType metaType,
                                   ManagedObjectImpl mo)
   {
      
      addManagedProperty(fieldName, fieldDescr, mandatory, isID, metaType, null, mo);
   }

   private void addManagedProperty(String fieldName,
                                   String fieldDescr,
                                   boolean mandatory,
                                   boolean isID,
                                   MetaType metaType,
                                   MetaValue value,
                                   ManagedObjectImpl mo)
   {
      DefaultFieldsImpl fields = new DefaultFieldsImpl();
      fields.setDescription(fieldDescr);
      fields.setMandatory(mandatory);
      fields.setMetaType(metaType);
      fields.setName(fieldName);
      ManagedPropertyImpl mp = new ManagedPropertyImpl(mo, fields);
      if(isID)
      {
         Map<String, Annotation> annotations = new HashMap<String, Annotation>();
         Map<String, Object> idFields = Collections.emptyMap();
         try
         {
            ManagementObjectID id = (ManagementObjectID) AnnotationProxy.createProxy(idFields, ManagementObjectID.class);
            annotations.put(ManagementObjectID.class.getName(), id);
            mp.setAnnotations(annotations);
         }
         catch(Exception e)
         {
            throw new UndeclaredThrowableException(e);
         }
      }

      super.addProperty(mp);
      if(value != null)
         mp.setValue(value);
   }
}
