/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metatype.plugins.values;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import java.util.WeakHashMap;
import javax.management.ObjectName;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.info.spi.PropertyInfo;
import org.jboss.config.plugins.property.PropertyConfiguration;
import org.jboss.config.spi.Configuration;
import org.jboss.metatype.api.types.ArrayMetaType;
import org.jboss.metatype.api.types.CollectionMetaType;
import org.jboss.metatype.api.types.CompositeMetaType;
import org.jboss.metatype.api.types.EnumMetaType;
import org.jboss.metatype.api.types.GenericMetaType;
import org.jboss.metatype.api.types.MapCompositeMetaType;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.types.MetaTypeFactory;
import org.jboss.metatype.api.types.PropertiesMetaType;
import org.jboss.metatype.api.types.SimpleMetaType;
import org.jboss.metatype.api.types.TableMetaType;
import org.jboss.metatype.api.values.ArrayValue;
import org.jboss.metatype.api.values.ArrayValueSupport;
import org.jboss.metatype.api.values.CollectionValue;
import org.jboss.metatype.api.values.CollectionValueSupport;
import org.jboss.metatype.api.values.CompositeValue;
import org.jboss.metatype.api.values.CompositeValueSupport;
import org.jboss.metatype.api.values.EnumValue;
import org.jboss.metatype.api.values.EnumValueSupport;
import org.jboss.metatype.api.values.GenericValue;
import org.jboss.metatype.api.values.GenericValueSupport;
import org.jboss.metatype.api.values.InstanceFactory;
import org.jboss.metatype.api.values.MapCompositeValueSupport;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.MetaValueFactory;
import org.jboss.metatype.api.values.PropertiesMetaValue;
import org.jboss.metatype.api.values.SimpleValue;
import org.jboss.metatype.api.values.SimpleValueSupport;
import org.jboss.metatype.api.values.TableValue;
import org.jboss.metatype.api.values.TableValueSupport;
import org.jboss.metatype.plugins.types.DefaultMetaTypeFactory;
import org.jboss.metatype.plugins.values.CompositeValueInvocationHandler;
import org.jboss.metatype.plugins.values.ListInstanceFactory;
import org.jboss.metatype.plugins.values.SetInstanceFactory;
import org.jboss.metatype.plugins.values.SortedSetInstanceFactory;
import org.jboss.metatype.plugins.values.mappers.PropertiesObjectNameMetaMapper;
import org.jboss.metatype.spi.values.MetaMapper;
import org.jboss.metatype.spi.values.MetaValueBuilder;
import org.jboss.reflect.plugins.introspection.ParameterizedClassInfo;
import org.jboss.reflect.spi.ArrayInfo;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.reflect.spi.TypeInfoFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMetaValueFactory
extends MetaValueFactory {
    private MetaTypeFactory metaTypeFactory = MetaTypeFactory.getInstance();
    private static final Map<Class<?>, Object> primitiveDefaultValueMap = new HashMap();
    private static Configuration configuration;
    private ThreadLocal<Stack<Map<Object, MetaValue>>> mappingStack = new ThreadLocal<Stack<Map<Object, MetaValue>>>(){

        @Override
        protected Stack<Map<Object, MetaValue>> initialValue() {
            return new Stack<Map<Object, MetaValue>>();
        }
    };
    private Map<Class<?>, WeakReference<MetaValueBuilder<?>>> builders = new WeakHashMap();
    private static final TypeInfo OBJECT_TYPE_INFO;
    private Map<Class<?>, InstanceFactory<?>> instanceFactoryMap = new WeakHashMap();

    public DefaultMetaValueFactory() {
        this.setInstanceFactory(List.class, ListInstanceFactory.INSTANCE);
        this.setInstanceFactory(Set.class, SetInstanceFactory.INSTANCE);
        this.setInstanceFactory(SortedSet.class, SortedSetInstanceFactory.INSTANCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBuilder(Class<?> clazz, MetaValueBuilder<?> builder) {
        Map<Class<?>, WeakReference<MetaValueBuilder<?>>> map = this.builders;
        synchronized (map) {
            if (builder == null) {
                this.builders.remove(clazz);
            }
            this.builders.put(clazz, new WeakReference(builder));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void setInstanceFactory(Class<T> clazz, InstanceFactory<T> factory) {
        Map<Class<?>, InstanceFactory<?>> map = this.instanceFactoryMap;
        synchronized (map) {
            if (factory == null) {
                this.instanceFactoryMap.remove(clazz);
            } else {
                this.instanceFactoryMap.put(clazz, factory);
            }
        }
    }

    public static SimpleValue createSimpleValue(SimpleMetaType type, Serializable value) {
        if (value == null) {
            return null;
        }
        return new SimpleValueSupport(type, value);
    }

    public static <T extends Enum<?>> EnumValue createEnumValue(EnumMetaType type, T value) {
        if (value == null) {
            return null;
        }
        return new EnumValueSupport(type, value.name());
    }

    public static GenericValue createGenericValue(GenericMetaType type, Object value, Map<Object, MetaValue> mapping) {
        if (value == null) {
            return null;
        }
        if (!(value instanceof Serializable)) {
            throw new IllegalArgumentException("Not serializable: " + value.getClass().getName());
        }
        GenericValueSupport result = new GenericValueSupport(type, (Serializable)value);
        mapping.put(value, result);
        return result;
    }

    public CollectionValue createCollectionValue(CollectionMetaType type, Object value, Map<Object, MetaValue> mapping) {
        if (value == null) {
            return null;
        }
        Collection collection = (Collection)value;
        MetaValue[] elements = new MetaValue[collection.size()];
        int i = 0;
        for (Object ce : collection) {
            TypeInfo typeInfo = configuration.getTypeInfo(ce.getClass());
            MetaType metaType = this.metaTypeFactory.resolve(typeInfo);
            elements[i++] = this.internalCreate(ce, typeInfo, metaType);
        }
        CollectionValueSupport result = new CollectionValueSupport(type, elements);
        mapping.put(value, result);
        return result;
    }

    public static Object[] convertPrimativeArray(TypeInfo type, Object value) {
        Object[] oa;
        if (value == null) {
            return null;
        }
        if (type instanceof ArrayInfo) {
            ArrayInfo arrayInfo = (ArrayInfo)ArrayInfo.class.cast(type);
            TypeInfo etype = arrayInfo.getComponentType();
            int size = Array.getLength(value);
            oa = new Object[size];
            for (int n = 0; n < size; ++n) {
                Object nvalue = Array.get(value, n);
                if (etype.isArray()) {
                    oa[n] = DefaultMetaValueFactory.convertPrimativeArray(etype, nvalue);
                }
                oa[n] = nvalue;
            }
        } else {
            oa = (Object[])value;
        }
        return oa;
    }

    public static Object mapNullToPrimitive(TypeInfo type) {
        return primitiveDefaultValueMap.get(type.getType());
    }

    public static Object[] convertPrimativeArray(Object value) {
        if (value == null) {
            return null;
        }
        return DefaultMetaValueFactory.convertPrimativeArray(configuration.getTypeInfo(value.getClass()), value);
    }

    public ArrayValue createArrayValue(ArrayMetaType type, Object value, Map<Object, MetaValue> mapping) {
        Object[] oldArray;
        Class<?> componentType;
        if (value == null) {
            return null;
        }
        ArrayValueSupport result = new ArrayValueSupport(type);
        mapping.put(value, result);
        MetaType elementType = type.getElementType();
        int dimension = type.getDimension();
        try {
            componentType = Class.forName(type.getClassName());
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to determine component type for " + type, e);
        }
        ClassInfo classInfo = configuration.getClassInfo(value.getClass());
        if (classInfo.isArray()) {
            ArrayInfo arrayInfo = (ArrayInfo)ArrayInfo.class.cast(classInfo);
            TypeInfo compInfo = arrayInfo.getComponentType();
            while (compInfo instanceof ArrayInfo) {
                arrayInfo = (ArrayInfo)ArrayInfo.class.cast(compInfo);
                compInfo = arrayInfo.getComponentType();
            }
            oldArray = compInfo.isPrimitive() ? DefaultMetaValueFactory.convertPrimativeArray((TypeInfo)classInfo, value) : (Object[])value;
        } else {
            throw new UnsupportedOperationException("Cannot construct array for " + value.getClass());
        }
        Object[] array = this.createArray(elementType, componentType.getComponentType(), dimension, oldArray);
        result.setValue(array);
        return result;
    }

    protected Object[] createArray(MetaType elementType, Class<?> componentType, int dimension, Object[] oldArray) {
        if (oldArray == null) {
            return null;
        }
        Object[] newArray = new Object[oldArray.length];
        if (dimension > 1) {
            for (int i = 0; i < oldArray.length; ++i) {
                Object[] result;
                Object[] nestedOld = !(oldArray[i] instanceof Object[]) ? DefaultMetaValueFactory.convertPrimativeArray(oldArray[i]) : (Object[])oldArray[i];
                newArray[i] = result = this.createArray(elementType, componentType.getComponentType(), dimension - 1, nestedOld);
            }
        } else {
            for (int i = 0; i < oldArray.length; ++i) {
                newArray[i] = this.internalCreate(oldArray[i], null, elementType);
            }
        }
        return newArray;
    }

    public CompositeValue createCompositeValue(CompositeMetaType type, Object value, Map<Object, MetaValue> mapping) {
        BeanInfo beanInfo;
        if (value == null) {
            return null;
        }
        if (type instanceof MapCompositeMetaType) {
            if (!(value instanceof Map)) {
                throw new RuntimeException("Expected Map value for: " + type + ", was: " + (value != null ? value.getClass() : "null"));
            }
            Map map = (Map)value;
            MapCompositeMetaType mapType = (MapCompositeMetaType)type;
            MetaType mapValueType = mapType.getValueType();
            MapCompositeValueSupport result = new MapCompositeValueSupport(mapValueType);
            for (Map.Entry entry : map.entrySet()) {
                Object entryValue = entry.getValue();
                MetaValue entryMetaValue = this.internalCreate(entryValue, null, mapValueType);
                result.put((String)entry.getKey(), entryMetaValue);
            }
            mapping.put(value, result);
            return result;
        }
        CompositeValueSupport result = new CompositeValueSupport(type);
        mapping.put(value, result);
        try {
            ClassLoader cl = value.getClass().getClassLoader();
            beanInfo = cl == null ? configuration.getBeanInfo(value.getClass()) : configuration.getBeanInfo(type.getTypeName(), cl);
        }
        catch (Exception e) {
            throw new RuntimeException("Error retrieving BeanInfo for " + type, e);
        }
        for (String name : type.itemSet()) {
            MetaType itemType = type.getType(name);
            Object itemValue = null;
            try {
                PropertyInfo property = beanInfo.getProperty(name);
                if (property.isReadable()) {
                    itemValue = beanInfo.getProperty(value, name);
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Error e) {
                throw e;
            }
            catch (Throwable t) {
                throw new RuntimeException("Error getting property: " + name + " for " + value.getClass(), t);
            }
            MetaValue item = this.internalCreate(itemValue, null, itemType);
            result.set(name, item);
        }
        return result;
    }

    public TableValue createTableValue(TableMetaType type, Map value, Map<Object, MetaValue> mapping) {
        if (value == null) {
            return null;
        }
        TableValueSupport table = new TableValueSupport(type);
        mapping.put(value, table);
        CompositeMetaType entryType = type.getRowType();
        MetaType keyType = entryType.getType("key");
        MetaType valType = entryType.getType("value");
        for (Map.Entry entry : value.entrySet()) {
            MetaValue key = this.internalCreate(entry.getKey(), null, keyType);
            MetaValue val = this.internalCreate(entry.getValue(), null, valType);
            CompositeValueSupport data = new CompositeValueSupport(entryType, DefaultMetaTypeFactory.MAP_ITEM_NAMES, new MetaValue[]{key, val});
            table.put(data);
        }
        return table;
    }

    @Override
    public MetaValue create(Object value) {
        return this.internalCreate(value, null, null);
    }

    @Override
    public MetaValue create(Object value, Type type) {
        TypeInfo typeInfo = configuration.getTypeInfo(type);
        return this.internalCreate(value, typeInfo, null);
    }

    @Override
    public MetaValue create(Object value, TypeInfo type) {
        return this.internalCreate(value, type, null);
    }

    @Override
    public MetaValue create(Object value, MetaType type) {
        return this.internalCreate(value, null, type);
    }

    @Override
    public Object unwrap(MetaValue metaValue) {
        return this.internalUnwrap(metaValue, null);
    }

    @Override
    public Object unwrap(MetaValue metaValue, Type type) {
        TypeInfo typeInfo = configuration.getTypeInfo(type);
        return this.internalUnwrap(metaValue, typeInfo);
    }

    @Override
    public Object unwrap(MetaValue metaValue, TypeInfo type) {
        return this.internalUnwrap(metaValue, type);
    }

    protected Object internalUnwrap(MetaValue metaValue, TypeInfo type) {
        if (metaValue == null) {
            return null;
        }
        MetaMapper<?> mapper = MetaMapper.getMetaMapper(type);
        if (mapper != null) {
            return mapper.unwrapMetaValue(metaValue);
        }
        MetaType metaType = metaValue.getMetaType();
        if (metaType.isSimple()) {
            Serializable value = ((SimpleValue)metaValue).getValue();
            Object v = this.getValue(metaType, type, value);
            if (v == null && metaType.isPrimitive()) {
                if (type == null) {
                    type = this.getTypeInfo(metaType, metaValue);
                }
                return DefaultMetaValueFactory.mapNullToPrimitive(type);
            }
            return v;
        }
        if (metaType.isEnum()) {
            String value = ((EnumValue)metaValue).getValue();
            return this.getValue(metaType, type, value);
        }
        if (metaType.isGeneric()) {
            Serializable value = ((GenericValue)metaValue).getValue();
            return this.getValue(metaType, type, value);
        }
        if (metaType.isArray()) {
            ArrayValue arrayValue = (ArrayValue)metaValue;
            if (type == null) {
                type = this.getTypeInfo(metaType, arrayValue.getValue());
            }
            Object array = this.newArrayInstance(type, arrayValue.getLength());
            for (int i = 0; i < Array.getLength(array); ++i) {
                Object element = arrayValue.getValue(i);
                if (element instanceof MetaValue) {
                    element = this.unwrapMetaValue((MetaValue)element, type, array);
                } else if (element != null && element.getClass().isArray()) {
                    element = this.unwrapArray(array, element);
                }
                Array.set(array, i, element);
            }
            return array;
        }
        if (metaType.isProperties()) {
            PropertiesMetaValue propsValue = (PropertiesMetaValue)metaValue;
            return this.unwrapProperties(propsValue, type);
        }
        if (metaType.isComposite()) {
            CompositeValue compositeValue = (CompositeValue)metaValue;
            return this.unwrapComposite(compositeValue, type);
        }
        if (metaType.isCollection()) {
            CollectionValue collectionValue = (CollectionValue)metaValue;
            return this.unwrapCollection(collectionValue, type);
        }
        if (metaType.isTable()) {
            TableValue tableValue = (TableValue)metaValue;
            return this.unwrapTable(tableValue, type);
        }
        throw new IllegalArgumentException("Unsupported meta value: " + metaValue.getMetaType());
    }

    protected TypeInfo checkTypeInfo(TypeInfo type, Object value, MetaType metaType) {
        if (type == null && value != null) {
            type = this.getTypeInfo(metaType, value);
        }
        return type;
    }

    protected Object getValue(MetaType metaType, TypeInfo typeInfo, Object value) {
        typeInfo = this.checkTypeInfo(typeInfo, value, metaType);
        return this.convertValue(value, typeInfo);
    }

    protected Object unwrapMetaValue(MetaValue element, TypeInfo type, Object array) {
        TypeInfo elementType = type instanceof ClassInfo ? ((ClassInfo)type).getComponentType() : this.getTypeInfo(element.getMetaType(), array);
        return this.unwrap(element, elementType);
    }

    protected Object unwrapArray(Object array, Object element) {
        TypeInfo elementType = configuration.getTypeInfo(array.getClass().getComponentType());
        int subSize = Array.getLength(element);
        Object newElement = this.newArrayInstance(elementType, subSize);
        for (int i = 0; i < subSize; ++i) {
            Object subElement = Array.get(element, i);
            if (subElement instanceof MetaValue) {
                subElement = this.unwrapMetaValue((MetaValue)subElement, elementType, newElement);
            }
            if (subElement != null && subElement.getClass().isArray()) {
                subElement = this.unwrapArray(newElement, subElement);
            }
            Array.set(newElement, i, subElement);
        }
        return newElement;
    }

    protected Object unwrapProperties(PropertiesMetaValue propsValue, TypeInfo type) {
        Class clazz = type.getType();
        if (clazz.isAssignableFrom(ObjectName.class)) {
            ObjectName name;
            String domainUnwrap = (String)propsValue.remove("domain");
            try {
                name = PropertiesObjectNameMetaMapper.createObjectName(domainUnwrap, propsValue);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to unwrap Properties to ObjectName", e);
            }
            return name;
        }
        return propsValue;
    }

    protected Object unwrapComposite(CompositeValue compositeValue, TypeInfo typeInfo) {
        CompositeMetaType compositeMetaType = compositeValue.getMetaType();
        String typeName = compositeMetaType.getTypeName();
        ClassLoader cl = typeInfo != null ? typeInfo.getType().getClassLoader() : Thread.currentThread().getContextClassLoader();
        try {
            BeanInfo beanInfo = configuration.getBeanInfo(typeName, cl);
            ClassInfo classInfo = beanInfo.getClassInfo();
            Class clazz = classInfo.getType();
            if (classInfo.isInterface()) {
                if (clazz.isAssignableFrom(Map.class)) {
                    return this.unwrapCompositeMap(compositeValue);
                }
                InvocationHandler handler = this.createCompositeValueInvocationHandler(compositeValue);
                Class[] interfaces = new Class[]{clazz};
                return Proxy.newProxyInstance(clazz.getClassLoader(), interfaces, handler);
            }
            if (clazz.isAssignableFrom(ObjectName.class)) {
                MetaValue domain = compositeValue.get("domain");
                String domainUnwrap = (String)this.unwrap(domain, (Type)((Object)String.class));
                MetaValue keys = compositeValue.get("keyPropertyList");
                PropertiesMetaValue keysUnwrap = null;
                if (keys instanceof PropertiesMetaValue) {
                    keysUnwrap = (PropertiesMetaValue)keys;
                }
                ObjectName name = new ObjectName(domainUnwrap, keysUnwrap);
                return name;
            }
            Object bean = this.createNewInstance(beanInfo);
            for (String name : compositeMetaType.itemSet()) {
                MetaValue itemValue = compositeValue.get(name);
                PropertyInfo propertyInfo = beanInfo.getProperty(name);
                Object value = this.unwrap(itemValue, propertyInfo.getType());
                propertyInfo.set(bean, value);
            }
            return bean;
        }
        catch (Throwable t) {
            throw new UndeclaredThrowableException(t);
        }
    }

    protected Map unwrapCompositeMap(CompositeValue compositeValue) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        CompositeMetaType metaType = compositeValue.getMetaType();
        for (String key : metaType.itemSet()) {
            MetaValue mv = compositeValue.get(key);
            Object value = this.unwrap(mv);
            map.put(key, value);
        }
        return map;
    }

    protected InvocationHandler createCompositeValueInvocationHandler(CompositeValue compositeValue) {
        return new CompositeValueInvocationHandler(compositeValue);
    }

    protected Object unwrapCollection(CollectionValue collectionValue, TypeInfo type) {
        try {
            BeanInfo collectionInfo;
            if (type instanceof ClassInfo) {
                collectionInfo = configuration.getBeanInfo(type);
            } else {
                CollectionMetaType metaType = collectionValue.getMetaType();
                collectionInfo = configuration.getBeanInfo(metaType.getTypeName(), Thread.currentThread().getContextClassLoader());
            }
            ClassInfo classInfo = collectionInfo.getClassInfo();
            Collection collection = (Collection)this.createNewInstance(collectionInfo);
            TypeInfo componentType = classInfo.getComponentType();
            boolean isObjectTypeInfo = OBJECT_TYPE_INFO.equals(componentType);
            for (MetaValue metaValue : collectionValue) {
                TypeInfo iterTypeInfo = isObjectTypeInfo ? this.getTypeInfo(metaValue.getMetaType(), null) : componentType;
                collection.add(this.unwrap(metaValue, iterTypeInfo));
            }
            return collection;
        }
        catch (Throwable t) {
            throw new UndeclaredThrowableException(t);
        }
    }

    protected Object unwrapTable(TableValue tableValue, TypeInfo type) {
        ParameterizedClassInfo parameterizedType;
        ClassInfo rawType;
        if (type instanceof ParameterizedClassInfo && Map.class.isAssignableFrom((rawType = (parameterizedType = (ParameterizedClassInfo)type).getRawType()).getType())) {
            TypeInfo keyType = parameterizedType.getActualTypeArguments()[0];
            TypeInfo valueType = parameterizedType.getActualTypeArguments()[1];
            return this.createMap(tableValue, keyType, valueType);
        }
        throw new UnsupportedOperationException("Insufficient information to unwrap table: " + tableValue + ", " + type);
    }

    protected Map<?, ?> createMap(TableValue tableValue, TypeInfo keyType, TypeInfo valueType) {
        if (tableValue == null) {
            return null;
        }
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        Collection<CompositeValue> values = tableValue.values();
        for (CompositeValue entry : values) {
            Object key = this.unwrap(entry.get("key"), keyType);
            Object val = this.unwrap(entry.get("value"), valueType);
            result.put(key, val);
        }
        return result;
    }

    protected MetaValue createPropertiesValue(PropertiesMetaType metaType, Object value, Map<Object, MetaValue> mapping) {
        if (value == null) {
            return null;
        }
        if (!(value instanceof Hashtable)) {
            throw new IllegalArgumentException("PropertiesMetaType requires a java.lang.Properties value, value.class: " + value.getClass());
        }
        Hashtable pvalue = (Hashtable)value;
        PropertiesMetaValue pmv = new PropertiesMetaValue();
        for (Object key : pvalue.keySet()) {
            if (!(key instanceof String)) {
                throw new IllegalArgumentException("key(" + key + ") is not a String");
            }
            String skey = (String)key;
            Object ovalue = pvalue.get(skey);
            if (!(key instanceof String)) {
                throw new IllegalArgumentException("value for key(" + key + ") is not a String, value.class: " + ovalue.getClass());
            }
            String svalue = (String)ovalue;
            pmv.setProperty(skey, svalue);
        }
        return pmv;
    }

    protected Object createNewInstance(BeanInfo beanInfo) throws Throwable {
        ClassInfo classInfo = beanInfo.getClassInfo();
        if (classInfo.isInterface()) {
            InstanceFactory<?> instanceFactory = this.instanceFactoryMap.get(classInfo.getType());
            if (instanceFactory == null) {
                throw new IllegalArgumentException("Cannot instantiate interface BeanInfo, missing InstanceFactory: " + classInfo);
            }
            return instanceFactory.instantiate(beanInfo);
        }
        return beanInfo.newInstance();
    }

    protected Object newArrayInstance(TypeInfo typeInfo, int size) {
        if (typeInfo == null) {
            throw new IllegalArgumentException("Null type info.");
        }
        try {
            return typeInfo.newArrayInstance(size);
        }
        catch (Throwable t) {
            throw new UndeclaredThrowableException(t);
        }
    }

    protected TypeInfo getTypeInfo(MetaType metaType, Object value) {
        if (metaType == null) {
            throw new IllegalArgumentException("Null meta type, cannot determine class name.");
        }
        if (value == null) {
            throw new IllegalArgumentException("Null value, cannot determine classloader.");
        }
        ClassLoader cl = value.getClass().getClassLoader();
        return this.getTypeInfo(metaType, cl);
    }

    protected TypeInfo getTypeInfo(MetaType metaType, ClassLoader cl) {
        if (cl == null) {
            cl = Thread.currentThread().getContextClassLoader();
        }
        try {
            TypeInfoFactory tif = configuration.getTypeInfoFactory();
            if (metaType.isArray()) {
                ArrayMetaType arrayMetaType = (ArrayMetaType)metaType;
                MetaType elementMetaType = arrayMetaType.getElementType();
                String elementTypeName = elementMetaType.getTypeName();
                if (arrayMetaType.isPrimitiveArray()) {
                    elementTypeName = ArrayMetaType.getPrimitiveName(elementTypeName);
                }
                TypeInfo elementTypeInfo = tif.getTypeInfo(elementTypeName, cl);
                TypeInfo typeInfo = elementTypeInfo.getArrayType();
                for (int dimension = arrayMetaType.getDimension() - 1; dimension > 0; --dimension) {
                    typeInfo = typeInfo.getArrayType();
                }
                return typeInfo;
            }
            return tif.getTypeInfo(metaType.getTypeName(), cl);
        }
        catch (ClassNotFoundException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MetaValue internalCreate(Object value, TypeInfo type, MetaType metaType) {
        MetaValue result;
        Map<Object, Object> mapping;
        if (value == null) {
            return null;
        }
        if (type == null) {
            type = configuration.getTypeInfo(value.getClass());
        }
        value = this.convertValue(value, type);
        boolean start = false;
        if (metaType == null) {
            start = true;
            metaType = this.metaTypeFactory.resolve(type);
        }
        if (start) {
            mapping = new HashMap();
            this.mappingStack.get().push(mapping);
        } else {
            mapping = this.mappingStack.get().peek();
            result = (MetaValue)mapping.get(value);
            if (result != null) {
                return result;
            }
        }
        try {
            MetaMapper<?> mapper;
            result = this.isBuilder(metaType, type, value, mapping);
            if (result == null && (mapper = MetaMapper.getMetaMapper(type)) != null) {
                result = mapper.createMetaValue(metaType, value);
            }
            if (result == null) {
                if (metaType.isSimple()) {
                    result = DefaultMetaValueFactory.createSimpleValue((SimpleMetaType)metaType, (Serializable)value);
                } else if (metaType.isEnum()) {
                    result = DefaultMetaValueFactory.createEnumValue((EnumMetaType)metaType, (Enum)value);
                } else if (metaType.isArray()) {
                    result = this.createArrayValue((ArrayMetaType)metaType, value, mapping);
                } else if (metaType.isComposite()) {
                    result = this.createCompositeValue((CompositeMetaType)metaType, value, mapping);
                } else if (metaType.isTable()) {
                    result = this.createTableValue((TableMetaType)metaType, (Map)value, mapping);
                } else if (metaType.isGeneric()) {
                    result = DefaultMetaValueFactory.createGenericValue((GenericMetaType)metaType, value, mapping);
                } else if (metaType.isCollection()) {
                    result = this.createCollectionValue((CollectionMetaType)metaType, value, mapping);
                } else if (metaType.isProperties()) {
                    result = this.createPropertiesValue((PropertiesMetaType)metaType, value, mapping);
                } else {
                    throw new IllegalStateException("Unknown metaType: " + metaType);
                }
            }
            MetaValue metaValue = result;
            return metaValue;
        }
        finally {
            if (start) {
                this.mappingStack.get().pop();
            }
        }
    }

    protected Object convertValue(Object value, TypeInfo typeInfo) {
        try {
            return typeInfo != null ? typeInfo.convertValue(value) : value;
        }
        catch (Throwable t) {
            throw new UndeclaredThrowableException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MetaValue isBuilder(MetaType metaType, TypeInfo type, Object value, Map<Object, MetaValue> mapping) {
        MetaValueBuilder builder = null;
        Map<Class<?>, WeakReference<MetaValueBuilder<?>>> map = this.builders;
        synchronized (map) {
            WeakReference<MetaValueBuilder<?>> weak = this.builders.get(type.getType());
            if (weak != null) {
                builder = (MetaValueBuilder)weak.get();
            }
        }
        if (builder == null) {
            return null;
        }
        MetaValue result = builder.buildMetaValue(metaType, value);
        if (result != null) {
            mapping.put(value, result);
        }
        return result;
    }

    static {
        primitiveDefaultValueMap.put(Byte.TYPE, (byte)0);
        primitiveDefaultValueMap.put(Boolean.TYPE, false);
        primitiveDefaultValueMap.put(Character.TYPE, Character.valueOf('0'));
        primitiveDefaultValueMap.put(Short.TYPE, (short)0);
        primitiveDefaultValueMap.put(Integer.TYPE, 0);
        primitiveDefaultValueMap.put(Long.TYPE, 0L);
        primitiveDefaultValueMap.put(Float.TYPE, Float.valueOf(0.0f));
        primitiveDefaultValueMap.put(Double.TYPE, 0.0);
        configuration = AccessController.doPrivileged(new PrivilegedAction<Configuration>(){

            @Override
            public Configuration run() {
                return new PropertyConfiguration();
            }
        });
        OBJECT_TYPE_INFO = configuration.getTypeInfo(Object.class);
    }
}

