/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metatype.plugins.types;

import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import org.jboss.metatype.api.types.AbstractMetaType;
import org.jboss.metatype.api.types.CompositeMetaType;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.values.CompositeValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCompositeMetaType
extends AbstractMetaType
implements CompositeMetaType {
    private static final long serialVersionUID = -7421421680257307598L;
    private TreeMap<String, String> nameToDescription;
    private TreeMap<String, MetaType> nameToType;
    private Set<String> keys;

    protected AbstractCompositeMetaType(String typeName, String description, String[] itemNames, String[] itemDescriptions, MetaType[] itemTypes, boolean ignoreItems) {
        super(CompositeValue.class.getName(), typeName, description);
        if (ignoreItems) {
            this.nameToDescription = new TreeMap();
            this.nameToType = new TreeMap();
            return;
        }
        if (itemNames == null || itemNames.length == 0) {
            throw new IllegalArgumentException("null or empty itemNames");
        }
        if (itemDescriptions == null || itemDescriptions.length == 0) {
            throw new IllegalArgumentException("null or empty itemDescriptions");
        }
        if (itemTypes == null || itemTypes.length == 0) {
            throw new IllegalArgumentException("null or empty itemTypes");
        }
        if (itemNames.length != itemDescriptions.length) {
            throw new IllegalArgumentException("wrong number of itemDescriptions");
        }
        if (itemNames.length != itemTypes.length) {
            throw new IllegalArgumentException("wrong number of itemTypes");
        }
        this.nameToDescription = new TreeMap();
        this.nameToType = new TreeMap();
        for (int i = 0; i < itemNames.length; ++i) {
            try {
                this.addItem(itemNames[i], itemDescriptions[i], itemTypes[i]);
                continue;
            }
            catch (IllegalArgumentException e) {
                IllegalArgumentException e1 = new IllegalArgumentException(e.getMessage() + " for item " + i);
                e1.setStackTrace(e.getStackTrace());
                throw e1;
            }
        }
    }

    protected AbstractCompositeMetaType(String typeName, String description) {
        this(typeName, description, null, null, null, true);
    }

    protected void setKeys(Set<String> keySet) {
        if (keySet != null) {
            for (String key : keySet) {
                if (this.containsItem(key)) continue;
                throw new IllegalArgumentException("Key " + key + " is not an item " + this.itemSet());
            }
        }
        this.keys = keySet;
    }

    protected void addItem(String itemName, String itemDescription, MetaType itemType) {
        if (itemName == null) {
            throw new IllegalArgumentException("null item name");
        }
        if ((itemName = itemName.trim()).length() == 0) {
            throw new IllegalArgumentException("empty item name");
        }
        if (this.nameToDescription.containsKey(itemName)) {
            throw new IllegalArgumentException("duplicate item name " + itemName);
        }
        if (itemDescription == null) {
            throw new IllegalArgumentException("null item description");
        }
        if ((itemDescription = itemDescription.trim()).length() == 0) {
            throw new IllegalArgumentException("empty item description");
        }
        if (itemType == null) {
            throw new IllegalArgumentException("null item type");
        }
        this.nameToDescription.put(itemName, itemDescription);
        this.nameToType.put(itemName, itemType);
    }

    @Override
    public boolean containsItem(String itemName) {
        if (itemName == null) {
            return false;
        }
        return this.nameToDescription.containsKey(itemName);
    }

    @Override
    public String getDescription(String itemName) {
        if (itemName == null) {
            return null;
        }
        return this.nameToDescription.get(itemName);
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    @Override
    public MetaType getType(String itemName) {
        if (itemName == null) {
            return null;
        }
        return this.nameToType.get(itemName);
    }

    @Override
    public Set<String> itemSet() {
        return Collections.unmodifiableSet(this.nameToDescription.keySet());
    }

    @Override
    public Set<String> keySet() {
        if (this.keys == null) {
            return this.itemSet();
        }
        return Collections.unmodifiableSet(this.keys);
    }

    @Override
    public boolean isValue(Object obj) {
        if (obj == null || !(obj instanceof CompositeValue)) {
            return false;
        }
        return this.equalsImpl(((CompositeValue)obj).getMetaType());
    }

    protected boolean equalsImpl(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof CompositeMetaType)) {
            return false;
        }
        CompositeMetaType other = (CompositeMetaType)obj;
        if (!this.getTypeName().equals(other.getTypeName())) {
            return false;
        }
        Iterator<String> thisNames = this.keySet().iterator();
        Iterator<String> otherNames = other.keySet().iterator();
        while (thisNames.hasNext() && otherNames.hasNext()) {
            String otherName;
            String thisName = thisNames.next();
            if (!thisName.equals(otherName = otherNames.next())) {
                return false;
            }
            if (this.getType(thisName).equals(other.getType(otherName))) continue;
            return false;
        }
        return !thisNames.hasNext() && !otherNames.hasNext();
    }

    protected int hashCodeImpl() {
        int hashCode = this.getTypeName().hashCode();
        for (MetaType metaType : this.nameToType.values()) {
            hashCode += metaType.hashCode();
        }
        for (String string : this.keySet()) {
            hashCode += string.hashCode();
        }
        return hashCode;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(this.getClass().getSimpleName());
        buffer.append('{').append(this.getTypeName());
        Iterator<String> thisNames = this.itemSet().iterator();
        if (thisNames.hasNext()) {
            buffer.append(" items=");
            while (thisNames.hasNext()) {
                String thisName = thisNames.next();
                buffer.append("[");
                buffer.append("name=");
                buffer.append(thisName);
                buffer.append(" type=");
                buffer.append(this.getType(thisName).getTypeName());
                buffer.append("]");
                if (!thisNames.hasNext()) continue;
                buffer.append(", ");
            }
        }
        buffer.append('}');
        return buffer.toString();
    }
}

