/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.plugins.repository.basic;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.metadata.plugins.loader.reflection.ClassMetaDataRetrievalFactory;
import org.jboss.metadata.plugins.repository.AbstractMetaDataRepository;
import org.jboss.metadata.plugins.repository.visitor.ChildrenMetaDataRepositoryVisitor;
import org.jboss.metadata.spi.repository.MutableMetaDataRepository;
import org.jboss.metadata.spi.repository.visitor.MetaDataRepositoryVisitor;
import org.jboss.metadata.spi.retrieval.MetaDataRetrieval;
import org.jboss.metadata.spi.retrieval.MetaDataRetrievalFactory;
import org.jboss.metadata.spi.scope.CommonLevels;
import org.jboss.metadata.spi.scope.Scope;
import org.jboss.metadata.spi.scope.ScopeKey;
import org.jboss.metadata.spi.scope.ScopeLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicMetaDataRepository
extends AbstractMetaDataRepository
implements MutableMetaDataRepository {
    private Map<ScopeKey, MetaDataRetrieval> retrievals = new ConcurrentHashMap<ScopeKey, MetaDataRetrieval>();
    private Map<ScopeLevel, MetaDataRetrievalFactory> factories = new ConcurrentHashMap<ScopeLevel, MetaDataRetrievalFactory>();

    public BasicMetaDataRepository() {
        this.addMetaDataRetrievalFactory(CommonLevels.CLASS, ClassMetaDataRetrievalFactory.INSTANCE);
    }

    @Override
    public MetaDataRetrieval getMetaDataRetrieval(ScopeKey key) {
        MetaDataRetrieval result = this.retrievals.get(key);
        if (result != null) {
            return result;
        }
        Collection<Scope> scopes = key.getScopes();
        if (scopes.size() != 1) {
            return null;
        }
        Scope scope = scopes.iterator().next();
        ScopeLevel scopeLevel = scope.getScopeLevel();
        MetaDataRetrievalFactory factory = this.getMetaDataRetrievalFactory(scopeLevel);
        if (factory == null) {
            return null;
        }
        return factory.getMetaDataRetrieval(scope);
    }

    @Override
    public Set<ScopeKey> getChildren(ScopeKey key) {
        if (key == null) {
            return this.retrievals.keySet();
        }
        ChildrenMetaDataRepositoryVisitor visitor = new ChildrenMetaDataRepositoryVisitor(key);
        return this.matchScopes(visitor);
    }

    @Override
    public Set<ScopeKey> matchScopes(MetaDataRepositoryVisitor visitor) {
        HashSet<ScopeKey> result = new HashSet<ScopeKey>();
        for (ScopeKey repositoryKey : this.retrievals.keySet()) {
            if (!visitor.matchScope(this, repositoryKey)) continue;
            result.add(repositoryKey);
        }
        return result;
    }

    @Override
    public MetaDataRetrieval addMetaDataRetrieval(MetaDataRetrieval retrieval) {
        if (retrieval == null) {
            throw new IllegalArgumentException("Null retrieval");
        }
        ScopeKey key = retrieval.getScope();
        key.freeze();
        return this.retrievals.put(key, retrieval);
    }

    @Override
    public MetaDataRetrieval removeMetaDataRetrieval(ScopeKey key) {
        if (key == null) {
            throw new IllegalArgumentException("Null key");
        }
        return this.retrievals.remove(key);
    }

    @Override
    public MetaDataRetrievalFactory addMetaDataRetrievalFactory(ScopeLevel level, MetaDataRetrievalFactory factory) {
        if (level == null) {
            throw new IllegalArgumentException("Null level");
        }
        if (factory == null) {
            throw new IllegalArgumentException("Null factory");
        }
        return this.factories.put(level, factory);
    }

    @Override
    public MetaDataRetrievalFactory getMetaDataRetrievalFactory(ScopeLevel level) {
        if (level == null) {
            throw new IllegalArgumentException("Null level");
        }
        return this.factories.get(level);
    }

    @Override
    public MetaDataRetrievalFactory removeMetaDataRetrievalFactory(ScopeLevel level) {
        if (level == null) {
            throw new IllegalArgumentException("Null level");
        }
        return this.factories.remove(level);
    }
}

