/*
 * JBoss, Home of Professional Open Source
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.managed.factory.support.deployment;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import javax.management.ObjectName;

import org.jboss.managed.api.ManagedOperation.Impact;
import org.jboss.managed.api.annotation.ManagementComponent;
import org.jboss.managed.api.annotation.ManagementObject;
import org.jboss.managed.api.annotation.ManagementOperation;
import org.jboss.metatype.api.annotations.MetaMapping;
import org.jboss.metatype.plugins.values.mappers.StringObjectNameMetaMapper;

/**
 * @author Scott.Stark@jboss.org
 * @version $Revision:$
 */
@ManagementObject(componentType=@ManagementComponent(type="JMSDestination", subtype="Queue"))
public class QueueDestination extends JmsDestination
   implements Serializable
{
   private static final long serialVersionUID = 1;

   @ManagementOperation(description="List all undelivered msgs", impact=Impact.ReadOnly)
   @MetaMapping(MessageListMapper.class)
   public List listAllMessages()
   {
      ArrayList<JBMessage> msgs = new ArrayList<JBMessage>();
      msgs.add(new JBMessage());
      return msgs;
   }

   @ManagementOperation(description="List all undelivered msgs", impact=Impact.ReadOnly)
   @MetaMapping(MessageListMapper.class)
   public List listAllMessages(@MetaMapping(StringObjectNameMetaMapper.class) ObjectName x)
   {
      ArrayList<JBMessage> msgs = new ArrayList<JBMessage>();
      msgs.add(new JBMessage());
      return msgs;
   }
}
