/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins;

import java.lang.reflect.Modifier;
import org.jboss.reflect.plugins.AnnotationHolder;
import org.jboss.reflect.spi.AnnotationValue;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.FieldInfo;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.util.JBossStringBuilder;
import org.jboss.util.NotImplementedException;

public class FieldInfoImpl
extends AnnotationHolder
implements FieldInfo {
    private static final long serialVersionUID = 3546084661584539959L;
    protected String name;
    protected TypeInfo type;
    protected int modifiers;
    protected ClassInfo declaringClass;
    protected int hash = -1;

    public FieldInfoImpl() {
    }

    public FieldInfoImpl(AnnotationValue[] annotations, String name, TypeInfo type, int modifiers, ClassInfo declaring) {
        super(annotations);
        this.name = name;
        this.type = type;
        this.modifiers = modifiers;
        this.declaringClass = declaring;
        this.calculateHash();
    }

    public String getName() {
        return this.name;
    }

    public TypeInfo getType() {
        return this.type;
    }

    public ClassInfo getDeclaringClass() {
        return this.declaringClass;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.modifiers);
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.modifiers);
    }

    public boolean isVolatile() {
        return Modifier.isVolatile(this.modifiers);
    }

    public Object get(Object target) throws Throwable {
        throw new NotImplementedException("get");
    }

    public Object set(Object target, Object value) throws Throwable {
        throw new NotImplementedException("set");
    }

    protected void toString(JBossStringBuilder buffer) {
        buffer.append("name=").append(this.name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof FieldInfo)) {
            return false;
        }
        FieldInfo other = (FieldInfo)obj;
        if (!this.name.equals(other.getName())) {
            return false;
        }
        return this.declaringClass.equals(other.getDeclaringClass());
    }

    public int hashCode() {
        return this.hash;
    }

    protected void calculateHash() {
        this.hash = this.name.hashCode();
    }
}

