/*
* JBoss, Home of Professional Open Source
* Copyright 2007, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.test.managed.factory.support.template;

import java.io.Serializable;

import org.jboss.managed.api.annotation.ManagementObject;
import org.jboss.managed.api.annotation.ManagementProperties;
import org.jboss.managed.api.annotation.ManagementProperty;

/**
 * Test explicit properties.
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision: 85266 $
 */
@ManagementObject(properties=ManagementProperties.EXPLICIT)
public class ManagementObjectExplicit implements Serializable
{
   /** The serialVersionUID */
   private static final long serialVersionUID = -1L;
   private String property1;

   /**
    * Get property 1
    * 
    * @return null
    */
   @ManagementProperty(includeInTemplate=true)
   public String getProperty1() 
   {
      return property1;
   }
   public void setProperty1(String value)
   {
      this.property1 = value;
   }

   /**
    * Get property 2
    * 
    * @return null
    */
   public String getProperty2() 
   {
      return null;
   }
}
