/*
 * JBoss, Home of Professional Open Source
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.managed.factory.support.deployment;

import java.io.Serializable;

import javax.management.ObjectName;

import org.jboss.managed.api.annotation.ManagementObject;
import org.jboss.managed.api.annotation.ManagementProperty;
import org.jboss.managed.api.annotation.RunStateProperty;
import org.jboss.managed.api.annotation.ViewUse;
import org.jboss.managed.plugins.factory.StringRunStateMapper;
import org.jboss.metatype.api.annotations.MetaMapping;
import org.jboss.metatype.plugins.values.mappers.StringObjectNameMetaMapper;

/**
 * @author Scott.Stark@jboss.org
 * @version $Revision:$
 */
@ManagementObject
public class JmsDestination
   implements Serializable
{
   private static final long serialVersionUID = 1;
   private String jndiName;
   private SecDomainMD domain;
   private String state;
   private ObjectName expiryQueue;

   
   @ManagementProperty(description="The expiry queue",
         use={ViewUse.RUNTIME}, includeInTemplate=true)
   @MetaMapping(StringObjectNameMetaMapper.class)
   protected ObjectName getExpiryQueue()
   {
      return expiryQueue;
   }
   protected void setExpiryQueue(ObjectName expiryQueue)
   {
      this.expiryQueue = expiryQueue;
   }

   @ManagementProperty(description="The destination state",
         use={ViewUse.STATISTIC}, includeInTemplate=false)
   @RunStateProperty(value=StringRunStateMapper.class,
         metaValues={"State0", "State1", "ErrorState"},
         enumValues={"RUNNING", "STOPPED", "FAILED"}
   )
   public String getState()
   {
      return state;
   }
   public void setState(String state)
   {
      this.state = state;
   }

   @ManagementProperty(description="JNDI binding location of destination", includeInTemplate=true)
   public String getJndiName()
   {
      return jndiName;
   }
   public void setJndiName(String jndiName)
   {
      this.jndiName = jndiName;
   }

   @ManagementProperty(use={ViewUse.STATISTIC}, includeInTemplate=false)
   public int getMsgCount()
   {
      return 0;
   }
   @ManagementProperty(description="Security domain information", managed=true)
   public SecDomainMD getDomain()
   {
      return domain;
   }
   public void setDomain(SecDomainMD domain)
   {
      this.domain = domain;
   }
}
