/*
 * JBoss, Home of Professional Open Source
 * Copyright 2009, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.managed.api;

/**
 * A common interface for managed elements that support transient attachments
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision: 87006 $
 */
public interface TransientAttachments
{
   /**
    * Get a transient attachment from the parameter.
    * 
    * @see #setTransientAttachment(String, Object)
    * 
    * @param name the name
    * @return the attachment
    */
   Object getTransientAttachment(String name);
   
   /**
    * Get an attachment from the parameter,
    * uses the expected type as both the name
    * and to cast the resulting object.
    * 
    * @param <T> the expected type
    * @param expectedType the expected type
    * @return the attachment
    * @throws ClassCastException when the object is not of the expected type
    */
   <T> T getTransientAttachment(Class<T> expectedType);

   /**
    * Set an transient attachment against the parameter. A transient attachment
    * is one that will not be available to clients of the parameter, typically
    * admin tools. Such attachments are used by the server side where the
    * underlying metadata to which the parameter is associated is available.
    * 
    * @param name the name
    * @param attachment the attachment, pass null to remove an attachment
    * @throws IllegalArgumentException for a null name
    */
   void setTransientAttachment(String name, Object attachment);
}
