/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metatype.api.types;

import java.io.ObjectStreamException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Comparator;
import java.util.Date;
import org.jboss.metatype.api.types.AbstractMetaType;
import org.jboss.metatype.api.types.Name;
import org.jboss.metatype.api.types.helpers.BigDecimalComparator;
import org.jboss.metatype.api.types.helpers.BigIntegerComparator;
import org.jboss.metatype.api.types.helpers.BooleanComparator;
import org.jboss.metatype.api.types.helpers.ByteComparator;
import org.jboss.metatype.api.types.helpers.CharacterComparator;
import org.jboss.metatype.api.types.helpers.DateComparator;
import org.jboss.metatype.api.types.helpers.DoubleComparator;
import org.jboss.metatype.api.types.helpers.FloatComparator;
import org.jboss.metatype.api.types.helpers.IntegerComparator;
import org.jboss.metatype.api.types.helpers.LongComparator;
import org.jboss.metatype.api.types.helpers.NamedComparator;
import org.jboss.metatype.api.types.helpers.ShortComparator;
import org.jboss.metatype.api.types.helpers.StringComparator;
import org.jboss.metatype.api.values.SimpleValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleMetaType
extends AbstractMetaType {
    private static final long serialVersionUID = 6786422588217893696L;
    private transient int cachedHashCode = this.getClassName().hashCode();
    private transient String cachedToString;
    public static final SimpleMetaType BIGDECIMAL = new SimpleMetaType(BigDecimal.class, BigDecimalComparator.INSTANCE);
    public static final SimpleMetaType BIGINTEGER = new SimpleMetaType(BigInteger.class, BigIntegerComparator.INSTANCE);
    public static final SimpleMetaType BOOLEAN = new SimpleMetaType(Boolean.class, BooleanComparator.INSTANCE);
    public static final SimpleMetaType BYTE = new SimpleMetaType(Byte.class, ByteComparator.INSTANCE);
    public static final SimpleMetaType CHARACTER = new SimpleMetaType(Character.class, CharacterComparator.INSTANCE);
    public static final SimpleMetaType DATE = new SimpleMetaType(Date.class, DateComparator.INSTANCE);
    public static final SimpleMetaType DOUBLE = new SimpleMetaType(Double.class, DoubleComparator.INSTANCE);
    public static final SimpleMetaType FLOAT = new SimpleMetaType(Float.class, FloatComparator.INSTANCE);
    public static final SimpleMetaType INTEGER = new SimpleMetaType(Integer.class, IntegerComparator.INSTANCE);
    public static final SimpleMetaType LONG = new SimpleMetaType(Long.class, LongComparator.INSTANCE);
    public static final SimpleMetaType SHORT = new SimpleMetaType(Short.class, ShortComparator.INSTANCE);
    public static final SimpleMetaType STRING = new SimpleMetaType(String.class, StringComparator.INSTANCE);
    public static final SimpleMetaType NAMEDOBJECT = new SimpleMetaType(Name.class, NamedComparator.INSTANCE);
    public static final SimpleMetaType VOID = new SimpleMetaType(Void.class, null);
    private transient Comparator comparator;

    public static SimpleMetaType resolve(String className) {
        SimpleMetaType result = SimpleMetaType.isSimpleType(className);
        if (result != null) {
            return result;
        }
        throw new IllegalArgumentException("Class is not a simple type: " + className);
    }

    public static SimpleMetaType isSimpleType(String className) {
        if (className == null) {
            throw new IllegalArgumentException("Null class name");
        }
        if (className.equals(STRING.getClassName())) {
            return STRING;
        }
        if (className.equals(INTEGER.getClassName()) || className.equals(Integer.TYPE.getName())) {
            return INTEGER;
        }
        if (className.equals(BOOLEAN.getClassName()) || className.equals(Boolean.TYPE.getName())) {
            return BOOLEAN;
        }
        if (className.equals(LONG.getClassName()) || className.equals(Long.TYPE.getName())) {
            return LONG;
        }
        if (className.equals(BYTE.getClassName()) || className.equals(Byte.TYPE.getName())) {
            return BYTE;
        }
        if (className.equals(CHARACTER.getClassName()) || className.equals(Character.TYPE.getName())) {
            return CHARACTER;
        }
        if (className.equals(DOUBLE.getClassName()) || className.equals(Double.TYPE.getName())) {
            return DOUBLE;
        }
        if (className.equals(FLOAT.getClassName()) || className.equals(Float.TYPE.getName())) {
            return FLOAT;
        }
        if (className.equals(SHORT.getClassName()) || className.equals(Short.TYPE.getName())) {
            return SHORT;
        }
        if (className.equals(BIGDECIMAL.getClassName())) {
            return BIGDECIMAL;
        }
        if (className.equals(BIGINTEGER.getClassName())) {
            return BIGINTEGER;
        }
        if (className.equals(VOID.getClassName()) || className.equals(Void.TYPE.getName())) {
            return VOID;
        }
        if (className.equals(DATE.getClassName())) {
            return DATE;
        }
        if (className.equals(NAMEDOBJECT.getClassName())) {
            return NAMEDOBJECT;
        }
        return null;
    }

    private SimpleMetaType(String className) {
        super(className);
        StringBuilder buffer = new StringBuilder(SimpleMetaType.class.getSimpleName());
        buffer.append(":");
        buffer.append(this.getClassName());
        this.cachedToString = buffer.toString();
    }

    private <T> SimpleMetaType(Class<T> clazz, Comparator<T> comparator) {
        this(clazz.getName());
        this.comparator = comparator;
    }

    public int compare(Object first, Object second) {
        if (this.comparator == null) {
            return 0;
        }
        if (first == null || second == null) {
            throw new IllegalArgumentException("Null objects to compare.");
        }
        return this.comparator.compare(first, second);
    }

    @Override
    public boolean isSimple() {
        return true;
    }

    @Override
    public boolean isValue(Object obj) {
        if (obj == null || !(obj instanceof SimpleValue)) {
            return false;
        }
        SimpleValue value = (SimpleValue)obj;
        return this.equals(value.getMetaType());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof SimpleMetaType)) {
            return false;
        }
        SimpleMetaType other = (SimpleMetaType)obj;
        return this.getClassName().equals(other.getClassName());
    }

    public int hashCode() {
        return this.cachedHashCode;
    }

    public String toString() {
        return this.cachedToString;
    }

    private Object readResolve() throws ObjectStreamException {
        return SimpleMetaType.resolve(this.getClassName());
    }
}

