/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metatype.plugins.values;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.jboss.metatype.api.values.CompositeValue;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.MetaValueFactory;
import org.jboss.util.UnreachableStatementException;

public class CompositeValueInvocationHandler
implements InvocationHandler,
Serializable {
    private static final long serialVersionUID = 1L;
    private static MetaValueFactory factory = MetaValueFactory.getInstance();
    private static final Map<Method, String> compositeDataKeyCache = Collections.synchronizedMap(new WeakHashMap());
    private CompositeValue compositeValue;

    public CompositeValueInvocationHandler(CompositeValue compositeValue) {
        if (compositeValue == null) {
            throw new IllegalArgumentException("Null compositeValue");
        }
        this.compositeValue = compositeValue;
    }

    public CompositeValue getCompositeValue() {
        return this.compositeValue;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (Object.class.equals(method.getDeclaringClass())) {
            return this.handleObjectInvocation(method.getName(), args);
        }
        MetaValue value = this.compositeValue.get(CompositeValueInvocationHandler.getCompositeDataKey(method));
        Type returnType = method.getGenericReturnType();
        return factory.unwrap(value, returnType);
    }

    private Object handleObjectInvocation(String name, Object[] args) throws Throwable {
        if ("equals".equals(name)) {
            Object object = args[0];
            if (object == null || !(object instanceof Proxy)) {
                return false;
            }
            InvocationHandler handler = Proxy.getInvocationHandler(object);
            if (handler == this) {
                return true;
            }
            if (handler == null || !(handler instanceof CompositeValueInvocationHandler)) {
                return false;
            }
            CompositeValueInvocationHandler other = (CompositeValueInvocationHandler)handler;
            return ((Object)this.getCompositeValue()).equals(other.getCompositeValue());
        }
        if ("hashCode".equals(name)) {
            return ((Object)this.getCompositeValue()).hashCode();
        }
        if ("toString".equals(name)) {
            return ((Object)this.getCompositeValue()).toString();
        }
        throw new UnreachableStatementException();
    }

    public static String getCompositeDataKey(Method method) {
        String key = compositeDataKeyCache.get(method);
        if (key != null) {
            return key;
        }
        StringBuilder fieldName = null;
        Class<?> returnType = method.getReturnType();
        Class<?>[] paramTypes = method.getParameterTypes();
        if (!Void.TYPE.equals(returnType) && paramTypes.length == 0) {
            String name = method.getName();
            if (name.startsWith("is") && name.length() > 2) {
                if (Boolean.TYPE.equals(returnType)) {
                    fieldName = new StringBuilder();
                    fieldName.append(Character.toLowerCase(name.charAt(2)));
                    if (name.length() > 3) {
                        fieldName.append(name.substring(3));
                    }
                }
            } else if (name.startsWith("get") && name.length() > 3) {
                fieldName = new StringBuilder();
                fieldName.append(Character.toLowerCase(name.charAt(3)));
                if (name.length() > 4) {
                    fieldName.append(name.substring(4));
                }
            }
        }
        if (fieldName == null) {
            return null;
        }
        String result = fieldName.toString();
        compositeDataKeyCache.put(method, result);
        return result;
    }
}

