/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.managed.api.factory;

import org.jboss.managed.api.factory.BaseManagedObjectDefinition;
import org.jboss.managed.api.factory.ManagedObjectFactory;
import org.jboss.managed.spi.factory.ManagedObjectBuilder;
import org.jboss.util.JBossStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurableManagedObjectDefinition
extends BaseManagedObjectDefinition {
    private ManagedObjectFactory factory;

    public ConfigurableManagedObjectDefinition() {
    }

    public ConfigurableManagedObjectDefinition(Class<?> type, ManagedObjectBuilder builder) {
        super(type, builder);
    }

    public ConfigurableManagedObjectDefinition(ManagedObjectFactory factory) {
        this(factory, null, null);
    }

    public ConfigurableManagedObjectDefinition(ManagedObjectFactory factory, Class<?> type, ManagedObjectBuilder builder) {
        super(type, builder);
        this.factory = factory;
    }

    protected ManagedObjectFactory getMOFactory() {
        if (this.factory == null) {
            this.factory = ManagedObjectFactory.getInstance();
        }
        return this.factory;
    }

    public void start() {
        if (!this.isValid()) {
            throw new IllegalArgumentException("Definition is invalid: " + this.toString());
        }
        this.getMOFactory().setBuilder(this.getType(), this.getBuilder());
    }

    public void stop() {
        if (this.factory == null) {
            throw new IllegalArgumentException("Missing managed object factory");
        }
        if (this.getType() == null) {
            throw new IllegalArgumentException("Missing type");
        }
        this.getMOFactory().setBuilder(this.getType(), null);
    }

    public ManagedObjectFactory getFactory() {
        return this.factory;
    }

    public void setFactory(ManagedObjectFactory factory) {
        this.factory = factory;
    }

    @Override
    public void toShortString(JBossStringBuilder buffer) {
        super.toShortString(buffer);
        buffer.append(", factory=").append((Object)this.factory);
    }

    @Override
    protected void toString(JBossStringBuilder buffer) {
        super.toString(buffer);
        buffer.append(", factory=").append((Object)this.factory);
    }
}

