/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.naming.remote.client;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.jboss.naming.remote.protocol.NamingIOException;

public class ClientUtil {
    public static NamingException namingException(String message, Throwable cause) {
        NamingException namingException = cause instanceof IOException ? new NamingIOException(message) : new NamingException(message);
        namingException.setRootCause(cause);
        return namingException;
    }

    public static boolean isEmpty(Name name) {
        return name.isEmpty() || name.size() == 1 && "".equals(name.get(0));
    }

    public static <T> NamingEnumeration<T> namingEnumeration(Collection<T> collection) {
        final Iterator<T> iterator = collection.iterator();
        return new NamingEnumeration<T>(){

            @Override
            public T next() {
                return this.nextElement();
            }

            @Override
            public boolean hasMore() {
                return this.hasMoreElements();
            }

            @Override
            public void close() {
            }

            @Override
            public boolean hasMoreElements() {
                return iterator.hasNext();
            }

            @Override
            public T nextElement() {
                return iterator.next();
            }
        };
    }
}

