/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jboss.forge.parser.java.JavaClass;
import org.jboss.forge.parser.java.JavaSource;
import org.jboss.forge.project.services.ResourceFactory;
import org.jboss.forge.resources.DirectoryResource;
import org.jboss.forge.resources.Resource;
import org.jboss.forge.resources.ResourceFilter;
import org.jboss.forge.resources.java.JavaMemberResource;
import org.jboss.forge.resources.java.JavaResource;
import org.jboss.forge.shell.util.PathspecParser;

public class ResourceUtil {
    public static File getContextFile(Resource<?> r) {
        do {
            Object o;
            if (!((o = r.getUnderlyingResourceObject()) instanceof File)) continue;
            return (File)r.getUnderlyingResourceObject();
        } while ((r = r.getParent()) != null);
        return null;
    }

    public static DirectoryResource getContextDirectory(Resource<?> r) {
        Resource<?> temp = r;
        do {
            if (!(temp instanceof DirectoryResource)) continue;
            return (DirectoryResource)temp;
        } while (temp != null && (temp = temp.getParent()) != null);
        return null;
    }

    public static List<Resource<?>> parsePathspec(ResourceFactory factory, Resource<?> resource, String pathspec) {
        return new PathspecParser(factory, resource, pathspec).resolve();
    }

    public static boolean isChildOf(Resource<?> parent, Resource<?> isChild) {
        Resource<?> r = isChild;
        while ((r = r.getParent()) != null) {
            if (!r.equals(parent)) continue;
            return true;
        }
        return false;
    }

    public static <E extends Resource<?>, R extends Collection<E>> R filter(ResourceFilter filter, Collection<E> list) {
        ArrayList<Resource> result = new ArrayList<Resource>();
        for (Resource resource : list) {
            if (!filter.accept(resource)) continue;
            result.add(resource);
        }
        return (R)result;
    }

    public static <E extends Resource<?>, R extends Collection<E>, I extends Collection<Resource<?>>> R filterByType(final Class<E> type, I list) {
        ResourceFilter filter = new ResourceFilter(){

            @Override
            public boolean accept(Resource<?> resource) {
                return type.isAssignableFrom(resource.getClass());
            }
        };
        return ResourceUtil.filter(filter, list);
    }

    public static boolean hasAnnotation(Resource<?> resource, Class<? extends Annotation> annotationClass) throws FileNotFoundException {
        if (resource == null) {
            throw new IllegalArgumentException("The parameter 'resource' cannot be null");
        }
        if (annotationClass == null) {
            throw new IllegalArgumentException("The parameter 'annotationClass' cannot be null");
        }
        if (resource instanceof JavaResource) {
            JavaClass javaClass = ResourceUtil.getJavaClassFromResource(resource);
            return javaClass.hasAnnotation(annotationClass);
        }
        if (resource instanceof JavaMemberResource) {
            JavaMemberResource javaMemberResource = (JavaMemberResource)resource;
            return javaMemberResource.getUnderlyingResourceObject().hasAnnotation(annotationClass);
        }
        throw new IllegalArgumentException("The given resource '" + resource.getName() + "' is not a Java resource");
    }

    public static JavaClass getJavaClassFromResource(Resource<?> resource) throws FileNotFoundException {
        if (resource == null) {
            throw new IllegalArgumentException("The parameter 'resource' cannot be null");
        }
        if (!(resource instanceof JavaResource)) {
            throw new IllegalArgumentException("The given resource '" + resource.getName() + "' is not a Java resource");
        }
        JavaResource javaResource = (JavaResource)resource;
        JavaSource<?> javaSource = javaResource.getJavaSource();
        if (!javaSource.isClass() && !javaSource.isInterface()) {
            throw new IllegalArgumentException("The given resource '" + resource.getName() + "' is not a class or an interface");
        }
        return (JavaClass)javaResource.getJavaSource();
    }
}

