/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell;

public enum PromptType {
    ANY(new String[]{".*"}),
    DEPENDENCY_ID(new String[]{"[^:]+:[^:]+:?([^:]+:?){0,3}"}),
    JAVA_PACKAGE(new String[]{"((?i)(~\\.)?([a-z0-9_]+\\.?)+[a-z0-9_])?", "^(?!.*\\b(abstract|continue|for|new|switch|assert|default|if|package|synchronized|boolean|do|goto|private|this|break|double|implements|protected|throw|byte|else|import|public|throws|case|enum|instanceof|return|transient|catch|extends|int|short|try|char|final|interface|static|void|class|finally|long|strictfp|volatile|const|float|native|super|while)\\b.*).*$"}),
    JAVA_VARIABLE_NAME(new String[]{"^(?!(abstract|continue|for|new|switch|assert|default|if|package|synchronized|boolean|do|goto|private|this|break|double|implements|protected|throw|byte|else|import|public|throws|case|enum|instanceof|return|transient|catch|extends|int|short|try|char|final|interface|static|void|class|finally|long|strictfp|volatile|const|float|native|super|while)$)[A-Za-z0-9$_]+$"}),
    JAVA_CLASS(new String[]{"(?i)(~\\.)?([a-z0-9_]+\\.?)+[a-z0-9_]", "^(?!.*\\b(abstract|continue|for|new|switch|assert|default|if|package|synchronized|boolean|do|goto|private|this|break|double|implements|protected|throw|byte|else|import|public|throws|case|enum|instanceof|return|transient|catch|extends|int|short|try|char|final|interface|static|void|class|finally|long|strictfp|volatile|const|float|native|super|while)\\b.*).*$"}),
    FILE_PATH(new String[]{".*"});

    private final String[] patterns;

    private PromptType(String[] patterns) {
        this.patterns = patterns;
    }

    public boolean matches(String value) {
        if (value == null) {
            return false;
        }
        for (int i = 0; i < this.patterns.length; ++i) {
            if (value.matches(this.patterns[i])) continue;
            return false;
        }
        return true;
    }
}

