/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.resources.java;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.forge.parser.java.Field;
import org.jboss.forge.parser.java.FieldHolder;
import org.jboss.forge.parser.java.JavaClass;
import org.jboss.forge.parser.java.JavaSource;
import org.jboss.forge.parser.java.Method;
import org.jboss.forge.parser.java.util.Strings;
import org.jboss.forge.resources.DeletionAware;
import org.jboss.forge.resources.Resource;
import org.jboss.forge.resources.ResourceFlag;
import org.jboss.forge.resources.java.JavaMemberResource;
import org.jboss.forge.resources.java.JavaMethodResource;
import org.jboss.forge.resources.java.JavaResource;

public class JavaFieldResource
extends JavaMemberResource<Field<? extends JavaSource<?>>>
implements DeletionAware {
    private final Field<? extends JavaSource<?>> field;

    public JavaFieldResource(JavaResource parent, Field<? extends JavaSource<?>> field) {
        super(parent, field);
        this.field = field;
        this.setFlag(ResourceFlag.Leaf);
    }

    @Override
    public Resource<Field<? extends JavaSource<?>>> createFrom(Field<? extends JavaSource<?>> file) {
        throw new RuntimeException("not implemented");
    }

    @Override
    protected List<Resource<?>> doListResources() {
        return Collections.emptyList();
    }

    @Override
    public Field<? extends JavaSource<?>> getUnderlyingResourceObject() {
        return this.field;
    }

    @Override
    public String getName() {
        return this.field.getName() + "::" + this.field.getType();
    }

    @Override
    public String toString() {
        return this.field.toString();
    }

    @Override
    public boolean delete() throws UnsupportedOperationException {
        JavaSource origin = (JavaSource)this.field.getOrigin();
        if (origin instanceof FieldHolder) {
            ((FieldHolder)origin).removeField(this.field);
            if (!((FieldHolder)origin).hasField(this.field)) {
                ((JavaResource)this.getParent()).setContents(origin.toString());
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean delete(boolean recursive) throws UnsupportedOperationException {
        return this.delete();
    }

    @Override
    public List<Resource<?>> getResources() {
        return null;
    }

    @Override
    public List<Resource<?>> getOptionalResources() {
        Method method;
        ArrayList result = new ArrayList();
        JavaClass entity = (JavaClass)this.field.getOrigin();
        String methodNameSuffix = Strings.capitalize((String)this.field.getName());
        if (entity.hasMethodSignature("get" + methodNameSuffix)) {
            method = entity.getMethod("get" + methodNameSuffix);
            result.add(new JavaMethodResource(this.getParent(), method));
        }
        if (entity.hasMethodSignature("set" + methodNameSuffix, new String[]{this.field.getQualifiedType()})) {
            method = entity.getMethod("set" + methodNameSuffix, new String[]{this.field.getQualifiedType()});
            result.add(new JavaMethodResource(this.getParent(), method));
        }
        return result;
    }
}

