/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.resources;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import javax.enterprise.inject.spi.BeanManager;
import org.jboss.forge.project.ProjectModelException;
import org.jboss.forge.project.services.ResourceFactory;
import org.jboss.forge.resources.AbstractResource;
import org.jboss.forge.resources.DirectoryResource;
import org.jboss.forge.resources.Resource;
import org.jboss.forge.resources.ResourceException;
import org.jboss.forge.resources.ResourceFlag;
import org.jboss.forge.resources.events.ResourceCreated;
import org.jboss.forge.resources.events.ResourceDeleted;
import org.jboss.forge.resources.events.ResourceModified;
import org.jboss.forge.resources.events.ResourceRenamed;
import org.jboss.forge.resources.events.TempResourceCreated;
import org.jboss.forge.shell.util.OSUtils;

public abstract class FileResource<T extends FileResource<?>>
extends AbstractResource<File> {
    protected boolean scratch;
    protected File file;
    protected File scratchFile;
    protected long lastModification;

    protected FileResource(ResourceFactory factory, File file) {
        super(factory, null);
        this.setFlag(ResourceFlag.File);
        this.file = file;
        if (this.file != null) {
            this.lastModification = file.lastModified();
        }
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public File getUnderlyingResourceObject() {
        if (this.scratch) {
            return this.scratchFile;
        }
        return this.file;
    }

    @Override
    public InputStream getResourceInputStream() {
        try {
            return new BufferedInputStream(new FileInputStream(this.file));
        }
        catch (FileNotFoundException e) {
            throw new ResourceException("cannot obtain stream to file: file does not exist: " + this.file.getAbsolutePath());
        }
    }

    @Override
    public Resource<?> getParent() {
        return this.file.getParentFile() != null ? new DirectoryResource(this.resourceFactory, this.file.getParentFile()) : null;
    }

    @Override
    public Resource<?> getChild(String name) {
        throw new ResourceException("[" + this.getClass().getSimpleName() + "] can have no children");
    }

    @Override
    public abstract Resource<File> createFrom(File var1);

    @Override
    public boolean exists() {
        return this.getUnderlyingResourceObject().exists();
    }

    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    public boolean isStale() {
        return this.lastModification != this.getUnderlyingResourceObject().lastModified();
    }

    public void markUpToDate() {
        this.lastModification = this.getUnderlyingResourceObject().lastModified();
    }

    public boolean mkdir() {
        if (this.file.mkdir()) {
            this.fireResourceCreated();
            return true;
        }
        return false;
    }

    public boolean mkdirs() {
        if (this.file.mkdirs()) {
            this.fireResourceCreated();
            return true;
        }
        return false;
    }

    @Override
    public boolean delete() {
        return this.delete(false);
    }

    @Override
    public boolean delete(boolean recursive) {
        if (recursive) {
            if (FileResource._deleteRecursive(this.file, true)) {
                this.fireResourceDeleted();
                return true;
            }
            return false;
        }
        if (this.file.listFiles() != null && this.file.listFiles().length != 0) {
            throw new RuntimeException("directory not empty");
        }
        if (OSUtils.isWindows()) {
            System.gc();
        }
        if (this.file.delete()) {
            this.fireResourceDeleted();
            return true;
        }
        return false;
    }

    public void deleteOnExit() {
        this.file.deleteOnExit();
    }

    private static boolean _deleteRecursive(File file, boolean collect) {
        if (collect && OSUtils.isWindows()) {
            System.gc();
        }
        if (file == null) {
            return false;
        }
        File[] children = file.listFiles();
        if (children != null) {
            for (File sf : children) {
                if (sf.isDirectory()) {
                    FileResource._deleteRecursive(sf, false);
                    continue;
                }
                if (sf.delete()) continue;
                throw new RuntimeException("failed to delete: " + sf.getAbsolutePath());
            }
        }
        return file.delete();
    }

    public T setContents(String data) {
        if (data == null) {
            data = "";
        }
        return this.setContents(data.toCharArray());
    }

    public T setContents(char[] data) {
        return this.setContents(new ByteArrayInputStream(new String(data).getBytes()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T setContents(InputStream data) {
        FileResource temp = null;
        try {
            if (!this.exists()) {
                this.mkdirs();
                this.delete();
                if (!this.createNewFile()) {
                    throw new IOException("Failed to create file: " + this.file);
                }
            }
            this.file.delete();
            FileOutputStream out = new FileOutputStream(this.file);
            try {
                int len;
                byte[] buf = new byte[1024];
                while ((len = data.read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
            }
            finally {
                if (data != null) {
                    data.close();
                }
                out.flush();
                ((OutputStream)out).close();
                if (OSUtils.isWindows()) {
                    System.gc();
                }
            }
            this.fireResourceModified();
        }
        catch (IOException e) {
            throw new ProjectModelException(e);
        }
        finally {
            if (temp != null) {
                temp.delete();
            }
        }
        return (T)this;
    }

    public boolean createNewFile() {
        try {
            if (this.file.mkdirs()) {
                this.file.delete();
            }
            if (this.file.createNewFile()) {
                this.fireResourceCreated();
                return true;
            }
            return false;
        }
        catch (IOException e) {
            throw new ProjectModelException(e);
        }
    }

    public T createTempResource() {
        try {
            FileResource result = (FileResource)this.createFrom(File.createTempFile("forgetemp", ""));
            this.fireTempResourceCreated(result);
            return (T)result;
        }
        catch (IOException e) {
            throw new ProjectModelException(e);
        }
    }

    private void fireTempResourceCreated(T result) {
        this.resourceFactory.getManagerInstance().fireEvent((Object)new TempResourceCreated((Resource<?>)result), new Annotation[0]);
    }

    @Override
    public <R extends Resource<?>> R reify(Class<R> type) {
        Resource<File> queryResult = this.resourceFactory.getResourceFrom(this.file);
        if (type.isAssignableFrom(queryResult.getClass())) {
            return (R)queryResult;
        }
        return null;
    }

    public boolean renameTo(String pathspec) {
        return this.renameTo(new File(pathspec));
    }

    public boolean renameTo(FileResource<?> target) {
        return this.renameTo(target.getUnderlyingResourceObject());
    }

    private boolean renameTo(File target) {
        File original = this.file.getAbsoluteFile();
        if (this.file.renameTo(target)) {
            this.fireResourceMoved(original);
            return true;
        }
        return false;
    }

    private void fireResourceMoved(File original) {
        BeanManager manager;
        if (this.resourceFactory != null && (manager = this.resourceFactory.getManagerInstance()) != null) {
            manager.fireEvent((Object)new ResourceRenamed(this, original.getAbsolutePath(), this.file.getAbsolutePath()), new Annotation[0]);
        }
    }

    private void fireResourceModified() {
        BeanManager manager;
        if (this.resourceFactory != null && (manager = this.resourceFactory.getManagerInstance()) != null) {
            manager.fireEvent((Object)new ResourceModified(this), new Annotation[0]);
        }
    }

    private void fireResourceCreated() {
        BeanManager manager;
        if (this.resourceFactory != null && (manager = this.resourceFactory.getManagerInstance()) != null) {
            manager.fireEvent((Object)new ResourceCreated(this), new Annotation[0]);
        }
    }

    private void fireResourceDeleted() {
        BeanManager manager;
        if (this.resourceFactory != null && (manager = this.resourceFactory.getManagerInstance()) != null) {
            manager.fireEvent((Object)new ResourceDeleted(this), new Annotation[0]);
        }
    }
}

