/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell;

import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jboss.forge.shell.Shell;
import org.jboss.forge.shell.events.CommandExecuted;

@Singleton
public class Wait {
    private static String[] spinnerChars = new String[]{"/", "-", "\\", "|"};
    private boolean complete = true;
    private Runnable runnable;
    private Thread thread;
    private Shell shell;

    @Inject
    public Wait(Shell shell) {
        this.shell = shell;
    }

    void cleanup(@Observes CommandExecuted event) {
        this.stop();
    }

    public void start() {
        this.start("Please wait");
    }

    public void start(String message) {
        this.runnable = new Runnable(){

            @Override
            public void run() {
                int i = 0;
                while (Wait.this.isWaiting()) {
                    Wait.this.shell.print(spinnerChars[i++]);
                    try {
                        Wait.this.shell.write(8);
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                    if (i != spinnerChars.length) continue;
                    i = 0;
                }
            }
        };
        try {
            this.shell.println();
            this.shell.print(message + "... ");
            this.complete = false;
            this.thread = new Thread(this.runnable);
            this.thread.start();
        }
        catch (Exception e) {
            this.stop();
        }
    }

    public void stop() {
        if (this.isWaiting()) {
            this.shell.println();
        }
        this.complete = true;
    }

    public boolean isWaiting() {
        return !this.complete;
    }
}

