/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.project;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.forge.project.Facet;
import org.jboss.forge.project.Project;
import org.jboss.forge.project.ProjectModelException;
import org.jboss.forge.project.facets.FacetNotFoundException;
import org.jboss.forge.shell.util.ConstraintInspector;

public abstract class BaseProject
implements Project {
    private final Set<Facet> facets = new HashSet<Facet>();
    private final Map<String, Object> attributes = new HashMap<String, Object>();

    @Override
    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    @Override
    public void setAttribute(String key, Object value) {
        this.attributes.put(key, value);
    }

    @Override
    public void removeAttribute(String key) {
        this.attributes.remove(key);
    }

    @Override
    public boolean hasFacet(Class<? extends Facet> type) {
        Facet result = null;
        for (Facet facet : this.facets) {
            if (facet == null || !type.isAssignableFrom(facet.getClass())) continue;
            result = facet;
            break;
        }
        return result != null;
    }

    @Override
    public boolean hasAllFacets(Class<? extends Facet> ... facetDependencies) {
        return this.hasAllFacets(Arrays.asList(facetDependencies));
    }

    @Override
    public boolean hasAllFacets(Collection<Class<? extends Facet>> facetDependencies) {
        for (Class<? extends Facet> type : facetDependencies) {
            if (this.hasFacet(type)) continue;
            return false;
        }
        return true;
    }

    @Override
    public <F extends Facet> F getFacet(Class<F> type) {
        Facet result = null;
        for (Facet facet : this.facets) {
            if (facet == null || !type.isAssignableFrom(facet.getClass())) continue;
            result = facet;
            break;
        }
        if (result == null) {
            throw new FacetNotFoundException("The requested facet of type [" + type.getName() + "] was not found. The facet is not installed.");
        }
        return (F)result;
    }

    public List<Facet> getFacets() {
        ArrayList<Facet> result = new ArrayList<Facet>();
        result.addAll(this.facets);
        return result;
    }

    public <F extends Facet> List<F> getFacets(Class<F> type) {
        ArrayList<Facet> result = new ArrayList<Facet>();
        for (Facet facet : this.facets) {
            if (facet == null || !facet.getClass().isAssignableFrom(type)) continue;
            result.add(facet);
        }
        return result;
    }

    @Override
    public Project registerFacet(Facet facet) {
        if (facet == null) {
            throw new IllegalArgumentException("Attempted to register 'null' as a Facet; Facets cannot be null.");
        }
        List<Class<? extends Facet>> dependencies = ConstraintInspector.getFacetDependencies(facet.getClass());
        for (Class<? extends Facet> type : dependencies) {
            if (this.hasFacet(type)) continue;
            throw new IllegalStateException("Attempting to register a Facet that has missing dependencies: [" + facet.getClass().getSimpleName() + " requires -> " + type.getSimpleName() + "]");
        }
        facet.setProject(this);
        if (facet.isInstalled() && !this.hasFacet(facet.getClass())) {
            this.facets.add(facet);
        }
        return this;
    }

    @Override
    public Project installFacet(Facet facet) {
        facet.setProject(this);
        if (!this.hasFacet(facet.getClass())) {
            this.performInstallation(facet);
        }
        return this;
    }

    @Override
    public Project removeFacet(Facet facet) {
        if (facet.isInstalled()) {
            this.performRemoval(facet);
        } else if (this.hasFacet(facet.getClass())) {
            this.unregisterFacet(facet);
        }
        return this;
    }

    @Override
    public Project unregisterFacet(Facet facet) {
        if (facet == null) {
            throw new IllegalArgumentException("Attempted to deregister 'null' as a Facet; Facets cannot be null.");
        }
        ArrayList<Facet> dependents = new ArrayList<Facet>();
        for (Facet f : this.getFacets()) {
            if (!ConstraintInspector.getFacetDependencies(f.getClass()).contains(facet.getClass())) continue;
            dependents.add(f);
        }
        for (Facet f : dependents) {
            if (!this.hasFacet(f.getClass())) continue;
            this.removeFacet(f);
        }
        if (!facet.isInstalled()) {
            this.facets.remove(facet);
        }
        return this;
    }

    private void performRemoval(Facet facet) {
        if (facet.uninstall()) {
            for (Facet f : this.facets) {
                if (!f.getClass().isAssignableFrom(facet.getClass())) continue;
                this.facets.remove(f);
                break;
            }
        } else {
            throw new ProjectModelException("Could not remove facet: [" + ConstraintInspector.getName(facet.getClass()) + "]. " + "Removal was unsuccessful.");
        }
    }

    private void performInstallation(Facet facet) {
        if (!facet.install()) {
            throw new ProjectModelException("Could not complete installation of facet: [" + ConstraintInspector.getName(facet.getClass()) + "]. " + "Installation was aborted by the Facet during installation.");
        }
        this.facets.add(facet);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getProjectRoot() == null ? 0 : this.getProjectRoot().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaseProject other = (BaseProject)obj;
        return !(this.getProjectRoot() == null ? other.getProjectRoot() != null : !this.getProjectRoot().equals(other.getProjectRoot()));
    }
}

