/*
 * JBoss, Home of Professional Open Source
 * Copyright 2011, Red Hat, Inc., and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.forge.project.dependencies;

import org.jboss.forge.parser.java.util.Strings;
import org.jboss.forge.project.facets.DependencyFacet.KnownRepository;

/**
 * @author <a href="mailto:lincolnbaxter@gmail.com">Lincoln Baxter, III</a>
 * 
 */
public class DependencyRepositoryImpl implements DependencyRepository
{
   private final String id;
   private final String url;

   public DependencyRepositoryImpl(final String id, final String url)
   {
      if (Strings.isNullOrEmpty(id))
      {
         throw new IllegalArgumentException("must specify repository id");
      }
      if (Strings.isNullOrEmpty(url))
      {
         throw new IllegalArgumentException("must specify repository url");
      }
      this.id = id;
      this.url = url;
   }

   public DependencyRepositoryImpl(KnownRepository repo)
   {
      this(repo.getId(), repo.getUrl());
   }

   @Override
   public String getId()
   {
      return id;
   }

   @Override
   public String getUrl()
   {
      return url;
   }

   @Override
   public String toString()
   {
      return "[id=" + id + ", url=" + url + "]";
   }

   @Override
   public int hashCode()
   {
      final int prime = 31;
      int result = 1;
      result = prime * result + ((id == null) ? 0 : id.hashCode());
      result = prime * result + ((url == null) ? 0 : url.hashCode());
      return result;
   }

   @Override
   public boolean equals(final Object obj)
   {
      if (this == obj)
         return true;
      if (obj == null)
         return false;
      if (getClass() != obj.getClass())
         return false;
      DependencyRepositoryImpl other = (DependencyRepositoryImpl) obj;
      if (id == null)
      {
         if (other.id != null)
            return false;
      }
      else if (!id.equals(other.id))
         return false;
      if (url == null)
      {
         if (other.url != null)
            return false;
      }
      else if (!url.equals(other.url))
         return false;
      return true;
   }

}
