/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.resources.java;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import org.jboss.forge.parser.JavaParser;
import org.jboss.forge.parser.ParserException;
import org.jboss.forge.parser.java.Field;
import org.jboss.forge.parser.java.JavaSource;
import org.jboss.forge.parser.java.Member;
import org.jboss.forge.parser.java.Method;
import org.jboss.forge.project.services.ResourceFactory;
import org.jboss.forge.resources.FileResource;
import org.jboss.forge.resources.Resource;
import org.jboss.forge.resources.ResourceException;
import org.jboss.forge.resources.ResourceFlag;
import org.jboss.forge.resources.ResourceHandles;
import org.jboss.forge.resources.java.JavaFieldResource;
import org.jboss.forge.resources.java.JavaMemberResource;
import org.jboss.forge.resources.java.JavaMethodResource;

@ResourceHandles(value={"*.java"})
public class JavaResource
extends FileResource<JavaResource> {
    @Inject
    public JavaResource(ResourceFactory factory) {
        super(factory, (File)null);
    }

    public JavaResource(ResourceFactory factory, File file) {
        super(factory, file);
        this.setFlag(ResourceFlag.ProjectSourceFile);
    }

    @Override
    public Resource<?> getChild(String name) {
        List<Resource<?>> children = this.listResources();
        ArrayList subset = new ArrayList();
        for (Resource<?> child : children) {
            if (name == null || !(child instanceof JavaMemberResource)) continue;
            String childName = child.getName();
            if (!((Member)child.getUnderlyingResourceObject()).getName().equals(name.trim()) && !childName.equals(name)) continue;
            subset.add(child);
        }
        if (subset.size() == 1) {
            return (Resource)subset.get(0);
        }
        if (subset.size() > 1) {
            throw new ResourceException("Ambiguous name [" + name + "], full type signature required");
        }
        return null;
    }

    @Override
    public synchronized List<Resource<?>> listResources() {
        try {
            LinkedList list = new LinkedList();
            for (Member member : this.getJavaSource().getMembers()) {
                if (member instanceof Field) {
                    list.add(new JavaFieldResource(this, (Field)member));
                    continue;
                }
                if (member instanceof Method) {
                    list.add(new JavaMethodResource((Resource<?>)this, (Method<? extends JavaSource<?>>)((Method)member)));
                    continue;
                }
                throw new UnsupportedOperationException("Unknown member type: " + member);
            }
            return list;
        }
        catch (ParserException e) {
            return Collections.emptyList();
        }
        catch (FileNotFoundException e) {
            return Collections.emptyList();
        }
    }

    public JavaResource setContents(JavaSource<?> source) {
        this.setContents(source.toString());
        return this;
    }

    public JavaSource<?> getJavaSource() throws FileNotFoundException {
        return JavaParser.parse((File)this.file);
    }

    public JavaResource createFrom(File file) {
        return new JavaResource(this.resourceFactory, file);
    }

    public String toString() {
        try {
            return this.getJavaSource().getQualifiedName();
        }
        catch (FileNotFoundException e) {
            throw new ResourceException(e);
        }
        catch (Exception e) {
            return this.getName();
        }
    }
}

