/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.resources;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.jboss.forge.project.ProjectModelException;
import org.jboss.forge.project.services.ResourceFactory;
import org.jboss.forge.resources.FileResource;
import org.jboss.forge.resources.Resource;
import org.jboss.forge.resources.ResourceException;
import org.jboss.forge.resources.ResourceFlag;
import org.jboss.forge.shell.util.OSUtils;

public class DirectoryResource
extends FileResource<DirectoryResource> {
    private volatile List<Resource<?>> listCache;

    public DirectoryResource(ResourceFactory factory, File file) {
        super(factory, file);
        this.setFlag(ResourceFlag.Node);
    }

    @Override
    public synchronized List<Resource<?>> listResources() {
        if (this.isStale()) {
            this.listCache = null;
        }
        if (this.listCache == null) {
            this.listCache = new LinkedList();
            File[] files = this.file.listFiles();
            if (files != null) {
                for (File f : files) {
                    this.listCache.add(this.resourceFactory.getResourceFrom(f));
                }
            }
        }
        return this.listCache;
    }

    @Override
    public Resource<?> getChild(String name) {
        return this.resourceFactory.getResourceFrom(new File(this.file.getAbsolutePath(), name));
    }

    public DirectoryResource getChildDirectory(String name) throws ResourceException {
        DirectoryResource result = this.getChild(name);
        if (!(result instanceof DirectoryResource) && result.exists()) {
            throw new ResourceException("The resource [" + result.getFullyQualifiedName() + "] is not a DirectoryResource");
        }
        if (!(result instanceof DirectoryResource)) {
            result = new DirectoryResource(this.resourceFactory, new File(this.file.getAbsoluteFile(), name));
        }
        return result;
    }

    public DirectoryResource getOrCreateChildDirectory(String name) {
        DirectoryResource child = this.getChildDirectory(name);
        if (!child.exists()) {
            child.mkdir();
        }
        return child;
    }

    public <E, T extends Resource<E>> T getChildOfType(Class<T> type, String name) throws ResourceException {
        Resource<Object> result;
        Resource<?> child = this.getChild(name);
        if (type.isAssignableFrom(child.getClass())) {
            result = child;
        } else {
            if (child.exists()) {
                throw new ResourceException("Requested resource [" + name + "] was not of type [" + type.getName() + "], but was instead [" + child.getClass().getName() + "]");
            }
            Object underlyingResource = child.getUnderlyingResourceObject();
            result = this.resourceFactory.createFromType(type, underlyingResource);
        }
        return (T)result;
    }

    @Override
    public DirectoryResource createTempResource() {
        try {
            File tempFile = File.createTempFile("forgetemp", "");
            tempFile.delete();
            return this.createFrom(tempFile);
        }
        catch (IOException e) {
            throw new ProjectModelException(e);
        }
    }

    public DirectoryResource createFrom(File file) {
        if (file.exists() && !file.isDirectory()) {
            throw new ResourceException("File reference is not a directory: " + file.getAbsolutePath());
        }
        if (!file.exists()) {
            file.mkdirs();
        }
        return new DirectoryResource(this.resourceFactory, file);
    }

    @Override
    public synchronized Resource<?> getParent() {
        if (this.parent == null) {
            File parentFile = this.file.getParentFile();
            if (parentFile == null) {
                return null;
            }
            this.parent = this.createFrom(parentFile);
        }
        return this.parent;
    }

    @Override
    public String getName() {
        String fileName = this.file.getName();
        return OSUtils.isWindows() && fileName.length() == 0 ? this.file.getPath() : fileName;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof DirectoryResource && ((DirectoryResource)obj).file.equals(this.file);
    }
}

