/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.resources;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.jboss.forge.project.services.ResourceFactory;
import org.jboss.forge.resources.Resource;
import org.jboss.forge.resources.ResourceFilter;
import org.jboss.forge.resources.ResourceFlag;

public abstract class AbstractResource<T>
implements Resource<T> {
    protected final ResourceFactory resourceFactory;
    protected Resource<?> parent;
    protected EnumSet<ResourceFlag> flags;

    protected AbstractResource(ResourceFactory factory, Resource<?> parent) {
        this.resourceFactory = factory;
        this.parent = parent;
    }

    @Override
    public ResourceFactory getResourceFactory() {
        return this.resourceFactory;
    }

    @Override
    public String getFullyQualifiedName() {
        return this.getParent() != null ? this.getParent().getFullyQualifiedName() + "/" + this.getName() : this.getName();
    }

    @Override
    public Resource<?> getParent() {
        return this.parent;
    }

    @Override
    public void setFlag(ResourceFlag flag) {
        if (this.flags == null) {
            this.flags = EnumSet.of(flag);
        } else {
            this.flags.add(flag);
        }
    }

    @Override
    public void unsetFlag(ResourceFlag flag) {
        if (this.flags != null) {
            this.flags.remove((Object)flag);
        }
    }

    @Override
    public boolean isFlagSet(ResourceFlag flag) {
        return this.flags != null && this.flags.contains((Object)flag);
    }

    @Override
    public Set<ResourceFlag> getFlags() {
        return Collections.unmodifiableSet(this.flags);
    }

    @Override
    public <R extends Resource<?>> R reify(Class<R> type) {
        if (type.isAssignableFrom(this.getClass())) {
            return (R)this;
        }
        return null;
    }

    @Override
    public synchronized List<Resource<?>> listResources(ResourceFilter filter) {
        ArrayList result = new ArrayList();
        for (Resource<?> resource : this.listResources()) {
            if (!filter.accept(resource)) continue;
            result.add(resource);
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Resource) {
            return ((Resource)obj).getFullyQualifiedName().equals(this.getFullyQualifiedName());
        }
        return false;
    }

    public int hashCode() {
        return this.getFullyQualifiedName().hashCode();
    }
}

