/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.project.dependencies;

import java.util.List;
import org.jboss.forge.project.dependencies.Dependency;
import org.jboss.forge.project.dependencies.DependencyImpl;
import org.jboss.forge.project.dependencies.ExcludedDependencyBuilder;
import org.jboss.forge.project.dependencies.ScopeType;
import org.jboss.forge.project.packaging.PackagingType;

public class DependencyBuilder
implements Dependency {
    private final DependencyImpl dep = new DependencyImpl();

    protected DependencyBuilder() {
    }

    public static DependencyBuilder create() {
        return new DependencyBuilder();
    }

    public static DependencyBuilder create(Dependency dep) {
        DependencyBuilder builder = new DependencyBuilder();
        builder.setGroupId(dep.getGroupId());
        builder.setArtifactId(dep.getArtifactId());
        builder.setVersion(dep.getVersion());
        builder.setPackagingType(dep.getPackagingType());
        builder.setScopeType(dep.getScopeType());
        builder.setClassifier(dep.getClassifier());
        return builder;
    }

    public static boolean areEquivalent(Dependency l, Dependency r) {
        if (l == r) {
            return true;
        }
        if (l == null && r == null) {
            return true;
        }
        if (l == null || r == null) {
            return false;
        }
        return !(l.getArtifactId() == null ? r.getArtifactId() != null : !l.getArtifactId().equals(r.getArtifactId())) && !(l.getGroupId() == null ? r.getGroupId() != null : !l.getGroupId().equals(r.getGroupId()));
    }

    public static DependencyBuilder create(String identifier) {
        DependencyBuilder dependencyBuilder = new DependencyBuilder();
        if (identifier != null) {
            String trimmed;
            String[] split = identifier.split(":");
            if (split.length > 0) {
                dependencyBuilder.setGroupId(split[0].trim());
            }
            if (split.length > 1) {
                dependencyBuilder.setArtifactId(split[1].trim());
            }
            if (split.length > 2) {
                dependencyBuilder.setVersion(split[2].trim());
            }
            if (split.length > 3) {
                trimmed = split[3].trim();
                ScopeType scopeType = ScopeType.from(trimmed);
                if (ScopeType.OTHER.equals((Object)scopeType)) {
                    dependencyBuilder.setScopeType(trimmed == null ? null : trimmed);
                } else {
                    dependencyBuilder.setScopeType(scopeType);
                }
            }
            if (split.length > 4) {
                trimmed = split[4].trim();
                PackagingType packaging = PackagingType.from(trimmed);
                if (PackagingType.OTHER.equals((Object)packaging)) {
                    dependencyBuilder.setPackagingType(trimmed == null ? null : trimmed);
                } else {
                    dependencyBuilder.setPackagingType(packaging);
                }
            }
        }
        return dependencyBuilder;
    }

    public DependencyBuilder setGroupId(String groupId) {
        this.dep.setGroupId(groupId);
        return this;
    }

    public DependencyBuilder setArtifactId(String artifactId) {
        this.dep.setArtifactId(artifactId);
        return this;
    }

    public DependencyBuilder setVersion(String version) {
        this.dep.setVersion(version);
        return this;
    }

    public DependencyBuilder setScopeType(ScopeType scope) {
        this.dep.setScopeType(scope);
        return this;
    }

    public DependencyBuilder setScopeType(String scope) {
        this.dep.setScopeType(scope);
        return this;
    }

    public DependencyBuilder setPackagingType(PackagingType type) {
        this.dep.setPackagingType(type);
        return this;
    }

    public DependencyBuilder setPackagingType(String type) {
        this.dep.setPackagingType(type);
        return this;
    }

    public DependencyBuilder setClassifier(String classifier) {
        this.dep.setClassifier(classifier);
        return this;
    }

    @Override
    public String getArtifactId() {
        return this.dep.getArtifactId();
    }

    @Override
    public String getGroupId() {
        return this.dep.getGroupId();
    }

    @Override
    public String getVersion() {
        return this.dep.getVersion();
    }

    @Override
    public String getScopeType() {
        return this.dep.getScopeType();
    }

    @Override
    public List<Dependency> getExcludedDependencies() {
        return this.dep.getExcludedDependencies();
    }

    public ExcludedDependencyBuilder addExclusion() {
        return this.addExclusion(this);
    }

    ExcludedDependencyBuilder addExclusion(DependencyBuilder parent) {
        ExcludedDependencyBuilder exclusion = ExcludedDependencyBuilder.create(parent);
        this.dep.getExcludedDependencies().add(exclusion);
        return exclusion;
    }

    @Override
    public String getPackagingType() {
        return this.dep.getPackagingType();
    }

    @Override
    public PackagingType getPackagingTypeEnum() {
        return this.dep.getPackagingTypeEnum();
    }

    @Override
    public ScopeType getScopeTypeEnum() {
        return this.dep.getScopeTypeEnum();
    }

    @Override
    public String getClassifier() {
        return this.dep.getClassifier();
    }

    public static String toId(Dependency dep) {
        String gav = dep.getGroupId() + ":" + dep.getArtifactId();
        gav = gav + ":" + (dep.getPackagingType() == null ? "" : dep.getPackagingType());
        gav = gav + ":" + (dep.getClassifier() == null ? "" : dep.getClassifier());
        gav = gav + ":" + (dep.getVersion() == null ? "" : dep.getVersion());
        return gav;
    }

    public static String toString(Dependency dep) {
        String gav = dep.toCoordinates();
        return gav;
    }

    @Override
    public String toCoordinates() {
        return DependencyBuilder.toId(this);
    }

    public String toString() {
        return DependencyBuilder.toString(this.dep);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dep == null ? 0 : this.dep.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DependencyBuilder other = (DependencyBuilder)obj;
        return !(this.dep == null ? other.dep != null : !this.dep.equals(other.dep));
    }
}

