/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.util;

import java.io.IOException;
import java.io.InputStream;
import org.jboss.forge.resources.DirectoryResource;
import org.jboss.forge.shell.ShellPrintWriter;

public class NativeSystemCall {
    public static int execFromPath(String command, String[] parms, ShellPrintWriter out, DirectoryResource path) throws IOException {
        try {
            int i;
            int read;
            String[] commandTokens = parms == null ? new String[1] : new String[parms.length + 1];
            commandTokens[0] = command;
            if (commandTokens.length > 1) {
                System.arraycopy(parms, 0, commandTokens, 1, parms.length);
            }
            Process p = Runtime.getRuntime().exec(commandTokens, null, path.getUnderlyingResourceObject());
            InputStream stdout = p.getInputStream();
            InputStream stderr = p.getErrorStream();
            byte[] buf = new byte[10];
            while ((read = stdout.read(buf)) != -1) {
                for (i = 0; i < read; ++i) {
                    out.write(buf[i]);
                }
            }
            while ((read = stderr.read(buf)) != -1) {
                for (i = 0; i < read; ++i) {
                    out.write(buf[i]);
                }
            }
            return p.waitFor();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static void exec(boolean wait, String command, String ... parms) throws IOException {
        String[] commandTokens = parms == null ? new String[1] : new String[parms.length + 1];
        commandTokens[0] = command;
        if (commandTokens.length > 1) {
            System.arraycopy(parms, 0, commandTokens, 1, parms.length);
        }
        Runtime.getRuntime().exec(commandTokens, null);
    }
}

