/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.project.services;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.jboss.forge.project.Facet;
import org.jboss.forge.project.facets.FacetNotFoundException;
import org.jboss.forge.shell.util.ConstraintInspector;

@Dependent
public class FacetFactory {
    private List<Facet> facets;
    private final Instance<? extends Facet> instances;

    @Inject
    public FacetFactory(@Any Instance<Facet> instances) {
        this.instances = instances;
    }

    public List<Facet> getFacets() {
        if (this.facets == null) {
            Iterator iterator = this.instances.iterator();
            ArrayList<Facet> result = new ArrayList<Facet>();
            while (iterator.hasNext()) {
                Facet element = (Facet)iterator.next();
                result.add(element);
            }
            this.facets = result;
        }
        return this.facets;
    }

    public <T extends Facet> T getFacet(Class<T> type) throws FacetNotFoundException {
        Facet result = null;
        for (Facet facet : this.getFacets()) {
            if (!type.isAssignableFrom(facet.getClass())) continue;
            result = facet;
            break;
        }
        if (result == null) {
            throw new FacetNotFoundException("The requested Facet of type [" + type.getName() + "] could not be loaded.");
        }
        return (T)result;
    }

    public Facet getFacetByName(String facetName) throws FacetNotFoundException {
        Facet result = null;
        for (Facet facet : this.getFacets()) {
            String name = ConstraintInspector.getName(facet.getClass());
            if (!name.equals(facetName)) continue;
            result = facet;
            break;
        }
        if (result == null) {
            throw new FacetNotFoundException("The requested Facet named [" + facetName + "] could not be found.");
        }
        return result;
    }
}

