/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.project.packaging;

public enum PackagingType {
    NONE("", "None"),
    BASIC("pom", "Basic Project"),
    JAR("jar", "Java Application"),
    WAR("war", "Java Web Application"),
    OTHER("", "Other packaging type");

    private String type;
    private String description;

    private PackagingType(String type, String description) {
        this.setType(type);
        this.setDescription(description);
    }

    public String getType() {
        return this.type;
    }

    private void setType(String type) {
        if (type != null) {
            type = type.trim().toLowerCase();
        }
        this.type = type;
    }

    public String toString() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    private void setDescription(String description) {
        this.description = description;
    }

    public static PackagingType from(String type) {
        PackagingType result = OTHER;
        if (type != null && !type.trim().isEmpty()) {
            type = type.trim();
            for (PackagingType p : PackagingType.values()) {
                if (!p.getType().equals(type) && !p.name().equalsIgnoreCase(type)) continue;
                result = p;
                break;
            }
        }
        return result;
    }
}

