/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.project.dependencies;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jboss.forge.project.dependencies.Dependency;
import org.jboss.forge.project.dependencies.DependencyMetadata;
import org.jboss.forge.project.dependencies.DependencyRepository;
import org.jboss.forge.project.dependencies.DependencyResolverProvider;
import org.jboss.forge.resources.DependencyResource;
import org.jboss.forge.shell.util.BeanManagerUtils;

@Singleton
public class DependencyResolver
implements DependencyResolverProvider {
    private final BeanManager manager;
    private List<DependencyResolverProvider> providers;

    @Inject
    public DependencyResolver(BeanManager manager) {
        this.manager = manager;
    }

    private void init() {
        if (this.providers == null || this.providers.isEmpty()) {
            this.providers = new ArrayList<DependencyResolverProvider>();
            ArrayList<DependencyResolverProvider> providers = new ArrayList<DependencyResolverProvider>();
            ServiceLoader<DependencyResolverProvider> loader = ServiceLoader.load(DependencyResolverProvider.class);
            for (DependencyResolverProvider p : loader) {
                providers.add(p);
            }
            for (DependencyResolverProvider p : providers) {
                DependencyResolverProvider instance = (DependencyResolverProvider)BeanManagerUtils.getContextualInstance(this.manager, p.getClass());
                if (instance == null) {
                    throw new IllegalStateException("Could not instantiate DependencyResolver of type [" + p.getClass().getName() + "]");
                }
                this.providers.add(instance);
            }
        }
        if (this.providers == null || this.providers.isEmpty()) {
            throw new IllegalStateException("No configured implementations for [" + DependencyResolverProvider.class.getName() + "] could be found.");
        }
    }

    @Override
    public List<DependencyResource> resolveArtifacts(Dependency query) {
        this.init();
        for (DependencyResolverProvider p : this.providers) {
            List<DependencyResource> artifacts = p.resolveArtifacts(query);
            if (artifacts == null || artifacts.isEmpty()) continue;
            return artifacts;
        }
        return new ArrayList<DependencyResource>();
    }

    @Override
    public List<DependencyResource> resolveArtifacts(Dependency query, DependencyRepository repository) {
        this.init();
        for (DependencyResolverProvider p : this.providers) {
            List<DependencyResource> artifacts = p.resolveArtifacts(query, repository);
            if (artifacts == null || artifacts.isEmpty()) continue;
            return artifacts;
        }
        return new ArrayList<DependencyResource>();
    }

    @Override
    public List<DependencyResource> resolveArtifacts(Dependency query, List<DependencyRepository> repositories) {
        this.init();
        for (DependencyResolverProvider p : this.providers) {
            List<DependencyResource> artifacts = p.resolveArtifacts(query, repositories);
            if (artifacts == null || artifacts.isEmpty()) continue;
            return artifacts;
        }
        return new ArrayList<DependencyResource>();
    }

    @Override
    public List<DependencyResource> resolveDependencies(Dependency query) {
        this.init();
        for (DependencyResolverProvider p : this.providers) {
            List<DependencyResource> artifacts = p.resolveDependencies(query);
            if (artifacts == null || artifacts.isEmpty()) continue;
            return artifacts;
        }
        return new ArrayList<DependencyResource>();
    }

    @Override
    public List<DependencyResource> resolveDependencies(Dependency query, DependencyRepository repository) {
        this.init();
        for (DependencyResolverProvider p : this.providers) {
            List<DependencyResource> artifacts = p.resolveDependencies(query, repository);
            if (artifacts == null || artifacts.isEmpty()) continue;
            return artifacts;
        }
        return new ArrayList<DependencyResource>();
    }

    @Override
    public List<DependencyResource> resolveDependencies(Dependency query, List<DependencyRepository> repositories) {
        this.init();
        for (DependencyResolverProvider p : this.providers) {
            List<DependencyResource> artifacts = p.resolveDependencies(query, repositories);
            if (artifacts == null || artifacts.isEmpty()) continue;
            return artifacts;
        }
        return new ArrayList<DependencyResource>();
    }

    @Override
    public DependencyMetadata resolveDependencyMetadata(Dependency query) {
        this.init();
        for (DependencyResolverProvider p : this.providers) {
            DependencyMetadata meta = p.resolveDependencyMetadata(query);
            if (meta == null) continue;
            return meta;
        }
        return null;
    }

    @Override
    public DependencyMetadata resolveDependencyMetadata(Dependency query, DependencyRepository repository) {
        this.init();
        for (DependencyResolverProvider p : this.providers) {
            DependencyMetadata meta = p.resolveDependencyMetadata(query, repository);
            if (meta == null) continue;
            return meta;
        }
        return null;
    }

    @Override
    public DependencyMetadata resolveDependencyMetadata(Dependency query, List<DependencyRepository> repositories) {
        this.init();
        for (DependencyResolverProvider p : this.providers) {
            DependencyMetadata meta = p.resolveDependencyMetadata(query, repositories);
            if (meta == null) continue;
            return meta;
        }
        return null;
    }

    @Override
    public List<Dependency> resolveVersions(Dependency query) {
        this.init();
        for (DependencyResolverProvider p : this.providers) {
            List<Dependency> artifacts = p.resolveVersions(query);
            if (artifacts == null || artifacts.isEmpty()) continue;
            return artifacts;
        }
        return new ArrayList<Dependency>();
    }

    @Override
    public List<Dependency> resolveVersions(Dependency query, DependencyRepository repository) {
        this.init();
        for (DependencyResolverProvider p : this.providers) {
            List<Dependency> artifacts = p.resolveVersions(query, repository);
            if (artifacts == null || artifacts.isEmpty()) continue;
            return artifacts;
        }
        return new ArrayList<Dependency>();
    }

    @Override
    public List<Dependency> resolveVersions(Dependency query, List<DependencyRepository> repositories) {
        this.init();
        for (DependencyResolverProvider p : this.providers) {
            List<Dependency> artifacts = p.resolveVersions(query, repositories);
            if (artifacts == null || artifacts.isEmpty()) continue;
            return artifacts;
        }
        return new ArrayList<Dependency>();
    }
}

