/*
 * JBoss, Home of Professional Open Source
 * Copyright 2011, Red Hat, Inc., and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.forge.scaffold;

import java.util.List;

import org.jboss.forge.parser.java.JavaClass;
import org.jboss.forge.project.Facet;
import org.jboss.forge.resources.Resource;
import org.jboss.forge.shell.plugins.Plugin;

/**
 * Provides an implementation of Scaffolding for various UI code generation operations.
 * 
 * @author <a href="mailto:lincolnbaxter@gmail.com">Lincoln Baxter, III</a>
 */
public interface ScaffoldProvider extends Facet
{
   /**
    * Set up this scaffold provider, installing any necessary {@link Facet} or {@link Plugin} implementations as
    * necessary. Use the given {@link Resource} as a template.
    */
   List<Resource<?>> setup(Resource<?> template, boolean overwrite);

   /**
    * Generate a base set of templates for use in generating resources.
    */
   List<Resource<?>> generateTemplates(boolean overwrite);

   /**
    * Create and configure the index pages for use in this application. Use the given {@link Resource} as a template.
    */
   List<Resource<?>> generateIndex(Resource<?> template, boolean overwrite);

   /**
    * Generate a set of create, read, update, delete pages for a given JPA entity {@link JavaClass}.
    */
   List<Resource<?>> generateFromEntity(Resource<?> template, JavaClass entity, boolean overwrite);

   /**
    * Attempt to locate all {@link Resource}s generated by this {@link ScaffoldProvider}.
    */
   List<Resource<?>> getGeneratedResources();

   /**
    * Get the {@link AccessStrategy} for this {@link ScaffoldProvider}.
    */
   AccessStrategy getAccessStrategy();

   /**
    * Get the {@link TemplateStrategy} for this {@link ScaffoldProvider}.
    */
   TemplateStrategy getTemplateStrategy();

}
