/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.parser.java.util;

public class Types {
    public static boolean areEquivalent(String left, String right) {
        if (left == null && right == null) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        if (left.equals(right)) {
            return true;
        }
        left = left.replaceAll("^(.*)<.*>$", "$1");
        right = right.replaceAll("^(.*)<.*>$", "$1");
        String l = Types.toSimpleName(left);
        String r = Types.toSimpleName(right);
        String lp = Types.getPackage(left);
        String rp = Types.getPackage(right);
        if (l.equals(r)) {
            return lp.isEmpty() || rp.isEmpty();
        }
        return false;
    }

    public static String toSimpleName(String fieldType) {
        String[] tokens;
        String result = fieldType;
        if (result != null && (tokens = Types.tokenizeClassName(result)) != null) {
            result = tokens[tokens.length - 1];
        }
        return result;
    }

    public static String[] tokenizeClassName(String className) {
        String[] result = null;
        if (className != null) {
            result = className.split("\\.");
        }
        return result;
    }

    public static boolean isQualified(String className) {
        String[] tokens = Types.tokenizeClassName(className);
        return tokens != null && tokens.length > 1;
    }

    public static String getPackage(String className) {
        if (className.indexOf(".") > -1) {
            return className.substring(0, className.lastIndexOf("."));
        }
        return "";
    }

    public static boolean isSimpleName(String name) {
        return name != null && name.matches("(?i)(?![0-9])[a-z0-9$_]+");
    }
}

