/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.parser.java.util;

import java.util.ArrayList;
import java.util.List;
import org.jboss.forge.parser.java.Field;
import org.jboss.forge.parser.java.JavaClass;
import org.jboss.forge.parser.java.Method;
import org.jboss.forge.parser.java.util.Strings;

public class Refactory {
    public static void createGetterAndSetter(JavaClass entity, Field<JavaClass> field) {
        if (!entity.hasField(field)) {
            throw new IllegalArgumentException("Entity did not contain the given field [" + field + "]");
        }
        entity.getMethods();
        String fieldName = field.getName();
        String methodNameSuffix = Strings.capitalize(fieldName);
        ((Method)entity.addMethod().setReturnType(field.getType()).setName("get" + methodNameSuffix).setPublic()).setBody("return this." + fieldName + ";");
        ((Method)entity.addMethod().setReturnTypeVoid().setName("set" + methodNameSuffix).setPublic()).setParameters("final " + field.getType() + " " + fieldName).setBody("this." + fieldName + " = " + fieldName + ";");
    }

    public static void createToStringFromFields(JavaClass entity) {
        List<Field<JavaClass>> fields = entity.getFields();
        Refactory.createToStringFromFields(entity, fields);
    }

    public static void createToStringFromFields(JavaClass entity, List<Field<JavaClass>> fields) {
        Method method = (Method)entity.addMethod().setName("toString").setReturnType(String.class).setPublic();
        ArrayList<String> list = new ArrayList<String>();
        String delimeter = "+ \", \" + ";
        for (Field<JavaClass> field : fields) {
            if (!entity.hasField(field)) continue;
            list.add(field.getName());
        }
        String body = "return this.getClass().getSimpleName() + \"[\" + " + Strings.join(list, delimeter) + " + \"]\";";
        method.setBody(body);
    }
}

