/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.container.versions;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.forge.container.versions.Version;

public class Versions {
    private static final Pattern VERSION_PATTERN = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)(\\.|-)(.*)");

    public static boolean isApiCompatible(Version runtimeVersion, Version addonApiVersion) {
        if (addonApiVersion == null || addonApiVersion.getVersionString().length() == 0 || runtimeVersion == null || runtimeVersion.getVersionString().length() == 0) {
            return true;
        }
        Matcher runtimeMatcher = VERSION_PATTERN.matcher(runtimeVersion.getVersionString());
        if (runtimeMatcher.matches()) {
            int runtimeMajorVersion = Integer.parseInt(runtimeMatcher.group(1));
            int runtimeMinorVersion = Integer.parseInt(runtimeMatcher.group(2));
            Matcher addonApiMatcher = VERSION_PATTERN.matcher(addonApiVersion.getVersionString());
            if (addonApiMatcher.matches()) {
                int addonApiMajorVersion = Integer.parseInt(addonApiMatcher.group(1));
                int addonApiMinorVersion = Integer.parseInt(addonApiMatcher.group(2));
                if (addonApiMajorVersion == runtimeMajorVersion && addonApiMinorVersion <= runtimeMinorVersion) {
                    return true;
                }
            }
        }
        return false;
    }
}

