/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.container.versions;

import org.jboss.forge.container.util.Assert;
import org.jboss.forge.container.versions.EmptyVersionRange;
import org.jboss.forge.container.versions.Version;
import org.jboss.forge.container.versions.VersionRange;

public class SingleVersionRange
implements VersionRange {
    private Version version;

    public SingleVersionRange(Version version) {
        Assert.notNull(version, "Version must not be null.");
        Assert.notNull(version.getVersionString(), "Version must not be null.");
        if (version.getVersionString().isEmpty()) {
            throw new IllegalArgumentException("Version must not be empty.");
        }
        this.version = version;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean isExact() {
        return true;
    }

    @Override
    public Version getMin() {
        return this.version;
    }

    @Override
    public Version getMax() {
        return this.version;
    }

    @Override
    public boolean includes(Version version) {
        return version != null && this.version.getVersionString().equals(version);
    }

    @Override
    public VersionRange getIntersection(VersionRange ... ranges) {
        for (VersionRange range : ranges) {
            if (!range.includes(this.version)) continue;
            return this;
        }
        return new EmptyVersionRange();
    }
}

