/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.container.repositories;

import org.jboss.forge.container.addons.AddonId;
import org.jboss.forge.container.util.Assert;

public class AddonDependencyEntry {
    private AddonId id;
    private boolean exported;
    private boolean optional;

    public AddonId getId() {
        return this.id;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public boolean isExported() {
        return this.exported;
    }

    public static AddonDependencyEntry create(AddonId id) {
        return AddonDependencyEntry.create(id, false, false);
    }

    public static AddonDependencyEntry create(AddonId id, boolean exported, boolean optional) {
        Assert.notNull(id, "AddonId must not be null.");
        AddonDependencyEntry entry = new AddonDependencyEntry();
        entry.id = id;
        entry.exported = exported;
        entry.optional = optional;
        return entry;
    }

    public String toString() {
        return this.id + ": exported=" + this.exported + ", optional=" + this.optional;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AddonDependencyEntry other = (AddonDependencyEntry)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }
}

