/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elemento.router.processor;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Modifier;
import org.jboss.elemento.router.processor.CodeGenerator;
import org.jboss.elemento.router.processor.RouteInfo;

class SimpleCodeGenerator
extends CodeGenerator {
    SimpleCodeGenerator() {
    }

    @Override
    void generateCode(Filer filer, String packageName, List<RouteInfo> routes) throws IOException {
        ClassName mapClass = ClassName.get("java.util", "Map", new String[0]);
        ClassName hashMapClass = ClassName.get("java.util", "HashMap", new String[0]);
        ClassName supplierClass = ClassName.get("java.util.function", "Supplier", new String[0]);
        ClassName pageClass = ClassName.get("org.jboss.elemento.router", "Page", new String[0]);
        ClassName placeClass = ClassName.get("org.jboss.elemento.router", "Place", new String[0]);
        ClassName routesClass = ClassName.get("org.jboss.elemento.router", "Routes", new String[0]);
        ClassName routesImplClass = ClassName.get(packageName, "RoutesImpl", new String[0]);
        FieldSpec instanceField = FieldSpec.builder(routesClass, "INSTANCE", new Modifier[0]).addModifiers(Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL).initializer("new $T()", routesImplClass).build();
        ParameterizedTypeName mapOfPlaceToSuppliersOfPage = ParameterizedTypeName.get(mapClass, placeClass, ParameterizedTypeName.get(supplierClass, pageClass));
        FieldSpec placesField = FieldSpec.builder(mapOfPlaceToSuppliersOfPage, "places", new Modifier[0]).addModifiers(Modifier.PRIVATE, Modifier.FINAL).build();
        MethodSpec.Builder constructorBuilder = MethodSpec.constructorBuilder().addModifiers(Modifier.PRIVATE).addStatement("this.$N = new $T<>()", "places", hashMapClass);
        for (RouteInfo route : routes) {
            if (route.title == null) {
                if (route.selector == null) {
                    constructorBuilder.addStatement("$N.put(new $T($S), () -> new $L())", "places", placeClass, route.route, route.pageClass);
                    continue;
                }
                constructorBuilder.addStatement("$N.put(new $T($S, null, $S), () -> new $L())", "places", placeClass, route.route, route.selector, route.pageClass);
                continue;
            }
            if (route.selector == null) {
                constructorBuilder.addStatement("$N.put(new $T($S, $S), () -> new $L())", "places", placeClass, route.route, route.title, route.pageClass);
                continue;
            }
            constructorBuilder.addStatement("$N.put(new $T($S, $S, $S), () -> new $L())", "places", placeClass, route.route, route.title, route.selector, route.pageClass);
        }
        MethodSpec constructor = constructorBuilder.build();
        MethodSpec placesMethod = MethodSpec.methodBuilder("places").addModifiers(Modifier.PUBLIC).returns(mapOfPlaceToSuppliersOfPage).addStatement("return places", new Object[0]).build();
        TypeSpec routesImplType = TypeSpec.classBuilder("RoutesImpl").addSuperinterface(routesClass).addModifiers(Modifier.PUBLIC).addFields(Arrays.asList(instanceField, placesField)).addMethods(Arrays.asList(constructor, placesMethod)).build();
        JavaFile javaFile = JavaFile.builder(packageName, routesImplType).build();
        javaFile.writeTo(filer);
    }
}

