/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elemento.router.processor;

import com.google.auto.common.BasicAnnotationProcessor;
import com.google.auto.common.MoreElements;
import com.google.auto.common.MoreTypes;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSetMultimap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import org.jboss.elemento.router.LoadData;
import org.jboss.elemento.router.Route;
import org.jboss.elemento.router.processor.CodeGenerator;
import org.jboss.elemento.router.processor.LoaderInfo;
import org.jboss.elemento.router.processor.LoaderStep;
import org.jboss.elemento.router.processor.RouteInfo;

class RouteStep
implements BasicAnnotationProcessor.Step {
    private final ProcessingEnvironment processingEnv;
    private final CodeGenerator codeGenerator;
    private final List<RouteInfo> routes;

    RouteStep(ProcessingEnvironment processingEnv, CodeGenerator codeGenerator) {
        this.processingEnv = processingEnv;
        this.codeGenerator = codeGenerator;
        this.routes = new ArrayList<RouteInfo>();
    }

    public Set<String> annotations() {
        return Set.of(Route.class.getName());
    }

    public Set<? extends Element> process(ImmutableSetMultimap<String, Element> elementsByAnnotation) {
        HashSet<Element> notReady = new HashSet<Element>();
        String packageName = this.processingEnv.getOptions().getOrDefault("places.package", "org.jboss.elemento.router");
        String className = this.processingEnv.getOptions().getOrDefault("places.class", "AnnotatedPlaces");
        for (Map.Entry entry : elementsByAnnotation.entries()) {
            Element element = (Element)entry.getValue();
            Route route = element.getAnnotation(Route.class);
            TypeElement pageType = MoreElements.asType((Element)element);
            RouteInfo routeInfo = new RouteInfo(Strings.emptyToNull((String)route.value()), Strings.emptyToNull((String)route.title()), Strings.emptyToNull((String)route.selector()), pageType.getQualifiedName().toString());
            this.processLoader(pageType, route, routeInfo, notReady);
            this.routes.add(routeInfo);
        }
        if (notReady.isEmpty() && !this.routes.isEmpty()) {
            try {
                this.codeGenerator.generateCode(this.processingEnv.getFiler(), packageName, className, this.routes);
            }
            catch (IOException e) {
                String error = String.format("Error writing code for %s.%s: %s", packageName, "AnnotatedPlaces", e.getMessage());
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, error);
            }
        }
        return notReady;
    }

    private void processLoader(TypeElement pageType, Route route, RouteInfo routeInfo, Set<Element> notReady) {
        ArrayList<ExecutableElement> exactMatches = new ArrayList<ExecutableElement>();
        ArrayList<ExecutableElement> possibleMatches = new ArrayList<ExecutableElement>();
        for (ExecutableElement method2 : this.possibleLoadersMethods(pageType)) {
            if (method2.getParameters().isEmpty() && method2.getModifiers().contains((Object)Modifier.PUBLIC)) {
                exactMatches.add(method2);
                continue;
            }
            possibleMatches.add(method2);
        }
        if (exactMatches.size() == 1) {
            routeInfo.loaderInfo = new LoaderInfo(pageType.getQualifiedName().toString(), ((ExecutableElement)exactMatches.get(0)).getSimpleName().toString());
        } else if (exactMatches.size() > 1) {
            String methods = exactMatches.stream().map(method -> method.getSimpleName().toString() + "()").collect(Collectors.joining(", ", "'", "'"));
            String error = String.format("Page %s has defined more than one public static loader method: %s", routeInfo.pageClass, methods);
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, error);
        }
        if (!possibleMatches.isEmpty()) {
            for (ExecutableElement possibleMatch : possibleMatches) {
                String parameters = possibleMatch.getParameters().stream().map(parameterType -> parameterType.asType().toString() + " " + parameterType.getSimpleName().toString()).collect(Collectors.joining(", "));
                String warning = String.format("Should the method '%s(%s)' in page %s act as a loader method? Loader methods must not have parameters.", possibleMatch.getSimpleName().toString(), parameters, routeInfo.pageClass);
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, warning, possibleMatch);
            }
        }
        if (Strings.emptyToNull((String)route.loader()) != null) {
            if (routeInfo.loaderInfo == null) {
                LoaderInfo loaderInfo = LoaderStep.loaderInfos.get(route.loader());
                if (loaderInfo != null) {
                    routeInfo.loaderInfo = loaderInfo;
                } else {
                    notReady.add(pageType);
                }
            } else {
                String error = String.format("Page %s has defined the public static loader method '%s()' and a reference to a named loader '%s'. Only one loader per page is allowed!", routeInfo.pageClass, routeInfo.loaderInfo.loaderMethod, route.loader());
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, error);
            }
        }
    }

    private List<ExecutableElement> possibleLoadersMethods(TypeElement pageType) {
        return pageType.getEnclosedElements().stream().filter(element -> element.getKind() == ElementKind.METHOD && element.getModifiers().contains((Object)Modifier.STATIC)).map(element -> (ExecutableElement)element).filter(method -> {
            TypeMirror returnType = method.getReturnType();
            return MoreTypes.isType((TypeMirror)returnType) && MoreTypes.isTypeOf(LoadData.class, (TypeMirror)returnType);
        }).collect(Collectors.toList());
    }
}

