/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elemento.router.processor;

import com.google.auto.common.BasicAnnotationProcessor;
import com.google.auto.common.MoreElements;
import com.google.auto.common.MoreTypes;
import com.google.auto.common.Visibility;
import com.google.common.collect.ImmutableSetMultimap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import org.jboss.elemento.router.LoadData;
import org.jboss.elemento.router.Loader;
import org.jboss.elemento.router.processor.LoaderInfo;

class LoaderStep
implements BasicAnnotationProcessor.Step {
    static final Map<String, LoaderInfo> loaderInfos = new HashMap<String, LoaderInfo>();
    private final ProcessingEnvironment processingEnv;

    LoaderStep(ProcessingEnvironment processingEnv) {
        this.processingEnv = processingEnv;
    }

    public Set<String> annotations() {
        return Set.of(Loader.class.getName());
    }

    public Set<? extends Element> process(ImmutableSetMultimap<String, Element> elementsByAnnotation) {
        for (Map.Entry entry : elementsByAnnotation.entries()) {
            ExecutableElement method;
            LoaderInfo loaderInfo;
            Element element = (Element)entry.getValue();
            Loader loader = element.getAnnotation(Loader.class);
            if (MoreElements.isType((Element)element)) {
                TypeElement type = MoreElements.asType((Element)element);
                if (!this.validLoaderType(type) || !this.uniqueLoader(loader.value(), element)) continue;
                loaderInfo = new LoaderInfo(type.getQualifiedName().toString(), null);
                loaderInfos.put(loader.value(), loaderInfo);
                continue;
            }
            if (element.getKind() != ElementKind.METHOD || !this.validLoaderMethod(method = MoreElements.asExecutable((Element)element)) || !this.uniqueLoader(loader.value(), element)) continue;
            loaderInfo = new LoaderInfo(MoreElements.asType((Element)method.getEnclosingElement()).getQualifiedName().toString(), method.getSimpleName().toString());
            loaderInfos.put(loader.value(), loaderInfo);
        }
        return Collections.emptySet();
    }

    private boolean validLoaderType(TypeElement type) {
        if (!type.getModifiers().contains((Object)Modifier.PUBLIC)) {
            String error = String.format("Class %s annotated with @%s is not public", type.getQualifiedName().toString(), Loader.class.getSimpleName());
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, error, type);
            return false;
        }
        if (type.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            String error = String.format("Class %s annotated with @%s is abstract", type.getQualifiedName().toString(), Loader.class.getSimpleName());
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, error, type);
            return false;
        }
        Set erasedInterfaces = type.getInterfaces().stream().map(interface_ -> this.processingEnv.getTypeUtils().erasure((TypeMirror)interface_).toString()).collect(Collectors.toSet());
        if (!erasedInterfaces.contains(LoadData.class.getName())) {
            String error = String.format("Class %s annotated with @%s does not implement %s<?>", type.getQualifiedName().toString(), Loader.class.getSimpleName(), LoadData.class.getSimpleName());
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, error, type);
            return false;
        }
        return true;
    }

    private boolean validLoaderMethod(ExecutableElement method) {
        boolean validSignature = false;
        if (method.getModifiers().containsAll(List.of(Modifier.PUBLIC, Modifier.STATIC)) && method.getParameters().isEmpty()) {
            TypeMirror returnType = method.getReturnType();
            boolean bl = validSignature = MoreTypes.isType((TypeMirror)returnType) && MoreTypes.isTypeOf(LoadData.class, (TypeMirror)returnType);
        }
        if (!validSignature) {
            String parameters = method.getParameters().stream().map(parameterType -> parameterType.asType().toString() + " " + parameterType.getSimpleName().toString()).collect(Collectors.joining(", "));
            String error = String.format("Method '%s(%s)' annotated with @%s is not a valid loader method. Valid loader methods have to be public static, return %s<?> and accept no parameters.", method.getSimpleName().toString(), parameters, Loader.class.getSimpleName(), LoadData.class.getSimpleName());
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, error, method);
            return false;
        }
        if (Visibility.effectiveVisibilityOfElement((Element)method) != Visibility.PUBLIC) {
            String error = String.format("Method '%s()' annotated with @%s is not publicly accessible.", method.getSimpleName().toString(), Loader.class.getSimpleName());
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, error, method);
            return false;
        }
        return true;
    }

    private boolean uniqueLoader(String name, Element element) {
        if (loaderInfos.containsKey(name)) {
            String error = String.format("Loader '%s' has already been defined.", name);
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, error, element);
        }
        return true;
    }
}

