/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elemento.router.processor;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Modifier;
import org.jboss.elemento.router.processor.RouteInfo;

abstract class CodeGenerator {
    private int counter = 0;

    CodeGenerator() {
    }

    final void generateCode(Filer filer, String packageName, String className, List<RouteInfo> routes) throws IOException {
        ClassName placeClass = ClassName.get((String)"org.jboss.elemento.router", (String)"Place", (String[])new String[0]);
        ClassName placesClass = ClassName.get((String)"org.jboss.elemento.router", (String)"Places", (String[])new String[0]);
        MethodSpec.Builder constructor = this.buildConstructor();
        routes.sort(Comparator.comparing(routeInfo -> routeInfo.route));
        for (RouteInfo route : routes) {
            String placeName = this.createPlace(constructor, placeClass, route);
            this.addPlace(constructor, placeName, route);
        }
        TypeSpec implType = TypeSpec.classBuilder((String)className).superclass((TypeName)placesClass).addModifiers(new Modifier[]{Modifier.PUBLIC}).addMethod(constructor.build()).build();
        JavaFile javaFile = JavaFile.builder((String)packageName, (TypeSpec)implType).build();
        javaFile.writeTo(filer);
    }

    abstract MethodSpec.Builder buildConstructor();

    String createPlace(MethodSpec.Builder constructor, ClassName placeClass, RouteInfo route) {
        String placeName = "place" + this.counter;
        CodeBlock.Builder builder = CodeBlock.builder();
        builder.add("$T $N = $T.place($S)", new Object[]{placeClass, placeName, placeClass, route.route});
        if (route.title != null) {
            builder.add("\n.title($S)", new Object[]{route.title});
        }
        if (route.selector != null) {
            builder.add("\n.root($S)", new Object[]{route.selector});
        }
        if (route.loaderInfo != null) {
            if (route.loaderInfo.loaderClass != null && route.loaderInfo.loaderMethod == null) {
                builder.add("\n.loader(new $L())", new Object[]{route.loaderInfo.loaderClass});
            } else {
                builder.add("\n.loader($L.$L())", new Object[]{route.loaderInfo.loaderClass, route.loaderInfo.loaderMethod});
            }
        }
        constructor.addStatement(builder.build());
        ++this.counter;
        return placeName;
    }

    abstract void addPlace(MethodSpec.Builder var1, String var2, RouteInfo var3);
}

