/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elemento.router.processor;

import com.google.auto.common.BasicAnnotationProcessor;
import com.google.auto.common.MoreElements;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSetMultimap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import org.jboss.elemento.router.Route;
import org.jboss.elemento.router.processor.CodeGenerator;
import org.jboss.elemento.router.processor.ProcessingException;
import org.jboss.elemento.router.processor.RouteInfo;

class RoutesStep
implements BasicAnnotationProcessor.Step {
    private final ProcessingEnvironment processingEnv;
    private final CodeGenerator codeGenerator;

    RoutesStep(ProcessingEnvironment processingEnv, CodeGenerator codeGenerator) {
        this.processingEnv = processingEnv;
        this.codeGenerator = codeGenerator;
    }

    public Set<String> annotations() {
        return Set.of(Route.class.getName());
    }

    public Set<? extends Element> process(ImmutableSetMultimap<String, Element> elementsByAnnotation) {
        ArrayList<RouteInfo> routes = new ArrayList<RouteInfo>();
        String packageName = this.processingEnv.getOptions().getOrDefault("routes.package", "org.jboss.elemento.router");
        for (Map.Entry entry : elementsByAnnotation.entries()) {
            Element element = (Element)entry.getValue();
            Route route = element.getAnnotation(Route.class);
            routes.add(new RouteInfo(Strings.emptyToNull((String)route.value()), Strings.emptyToNull((String)route.title()), Strings.emptyToNull((String)route.selector()), MoreElements.asType((Element)element).getQualifiedName().toString()));
        }
        if (!routes.isEmpty()) {
            try {
                this.codeGenerator.generateCode(this.processingEnv.getFiler(), packageName, routes);
            }
            catch (IOException e) {
                throw new ProcessingException("Error writing code for " + packageName + ".RoutesImpl: " + e.getMessage());
            }
        }
        return Collections.emptySet();
    }
}

